/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netdb.h>

#include "lopster.h"
#include "global.h"
#include "support.h"
#include "dirselect.h"
#include "scheme.h"
#include "filetips.h"
#include "utils.h"

#define ROW_TOP_YPIXEL(clist, row) (((clist)->row_height * (row)) + \
                                    ((row) + 1) + \
                                    (clist)->voffset)
#define COLUMN_LEFT_XPIXEL(clist, col)  ((clist)->column[(col)].area.x + \
                                            (clist)->hoffset)


file_tips_t filetips;

void filetips_init()
{
  filetips.widget = NULL;
  filetips.tips = NULL;
  filetips.file = NULL;
  filetips.row = -1;
  filetips.timeout = -1;
}

static gint filetips_paint_window() {
  GtkStyle *style;
  gint y, baseline_skip, gap;
  char *text;
  file_t *file;

  if (!filetips.tips)
    return 0;
  if (!filetips.file)
    return 0;
  style = filetips.tips->style;
  file = filetips.file,
      gap = (style->font->ascent + style->font->descent) / 4;
  if (gap < 2)
    gap = 2;
  baseline_skip = style->font->ascent + style->font->descent + gap;

  gtk_paint_flat_box(style, filetips.tips->window,
		     GTK_STATE_NORMAL, GTK_SHADOW_OUT,
		     NULL, GTK_WIDGET(filetips.tips), "tooltip",
		     0, 0, -1, -1);
  y = style->font->ascent + 4;

  text = l_strdup_printf("Size: %lu", file->size);
  gtk_paint_string(style, filetips.tips->window,
		   GTK_STATE_NORMAL,
		   NULL, GTK_WIDGET(filetips.tips), "tooltip", 4, y, text);
  l_free(text);
  y += baseline_skip;
  text =
      l_strdup_printf("IP: %s",
		      (!file->net) ? "unknown" : (ntoa(file->ip)));
  gtk_paint_string(style, filetips.tips->window, GTK_STATE_NORMAL, NULL,
		   GTK_WIDGET(filetips.tips), "tooltip", 4, y, text);
  l_free(text);
  y += baseline_skip;

  return 0;
}

void filetips_show_window()
{
  if (!filetips.file)
    return;

  if (filetips.tips)
    return;
  
  filetips.tips = gtk_window_new(GTK_WINDOW_POPUP);
  gtk_widget_set_app_paintable(filetips.tips, TRUE);
  gtk_window_set_policy(GTK_WINDOW(filetips.tips), FALSE, FALSE, TRUE);
  gtk_widget_set_name(filetips.tips, "gtk-tooltips");
  gtk_signal_connect_object(GTK_OBJECT(filetips.tips),
			    "expose_event",
			    GTK_SIGNAL_FUNC(filetips_paint_window), NULL);
  gtk_signal_connect_object(GTK_OBJECT(filetips.tips),
			    "draw",
			    GTK_SIGNAL_FUNC(filetips_paint_window), NULL);

  return;
}

int filetips_show_real(gpointer data ATTR_UNUSED)
{
  GtkStyle *style;
  gint gap, x, y, w, h, scr_w, scr_h, baseline_skip;
  int w2;
  char* text;

  gtk_timeout_remove(filetips.timeout);
  filetips.timeout = -1;

  filetips_show_window();

  gtk_widget_ensure_style(filetips.tips);
  style = filetips.tips->style;

  scr_w = gdk_screen_width();
  scr_h = gdk_screen_height();

  gap = (style->font->ascent + style->font->descent) / 4;
  if (gap < 2)
    gap = 2;
  baseline_skip = style->font->ascent + style->font->descent + gap;

  text = l_strdup_printf("Size: %lu", filetips.file->size);
  w = gdk_string_width(style->font, text);
  l_free(text);
  text = l_strdup_printf("IP: %s",
			 (!filetips.file->net) ? "local" : (ntoa(filetips.file->ip)));
  w2 = gdk_string_width(style->font, text);
  l_free(text);
  if (w2 > w) w = w2;

  w += 10;
  h = 8 - gap;
  h += 2 * baseline_skip;
  if (h < 8)
    h = 8;

  gdk_window_get_origin(GTK_CLIST(filetips.widget)->clist_window, &x, &y);

  x += COLUMN_LEFT_XPIXEL(GTK_CLIST(filetips.widget), filetips.col);
  y += ROW_TOP_YPIXEL(GTK_CLIST(filetips.widget), filetips.row);

  x -= (w+3);
  y -= (3+4);

  if ((x + w) > scr_w)
    x -= (x + w) - scr_w;
  else if (x < 0)
    x = 0;

  if ((y + h + 4) > scr_h)
    y = y - h - 4;
  else
    y = y + 4;

  gtk_widget_set_usize(filetips.tips, w, h);
  gtk_widget_popup(filetips.tips, x, y);

  return 0;
}

void filetips_show(GtkWidget * temp, int row, int col, file_t * file)
{
  if (filetips.file == file)
    return;

  if (filetips.timeout >= 0)
    gtk_timeout_remove(filetips.timeout);
  filetips.timeout = -1;
  if (filetips.tips)
    gtk_widget_destroy(filetips.tips);
  filetips.tips = NULL;

  filetips.widget = temp;
  filetips.row = row;
  filetips.col = col;
  filetips.file = file;
  if (filetips.file)
    filetips.timeout = gtk_timeout_add(500, filetips_show_real, NULL);
}
