/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <time.h>
#include <string.h>
#include <sys/time.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "lopster.h"
#include "global.h"
#include "chat.h"
#include "support.h"
#include "handler.h"
#include "connection.h"
#include "string_list.h"

// case insensitive string lists

void string_list_clear(int lists)
{
  int i1;
  GList *dlist;
  GtkCList *clist;

  for (i1 = 0; i1 < STRING_LIST_NO; i1++) {
    if ((lists & (1 << i1)) == 0)
      continue;
    for (dlist = global.string_list[i1]; dlist; dlist = dlist->next) {
      l_free(dlist->data);
    }
    if (global.string_list[i1]) {
      g_list_free(global.string_list[i1]);
      global.string_list[i1] = NULL;
    }
    if (global.string_win) {
      clist = string_list_get_clist(i1);
      if (clist) gtk_clist_clear(clist);
    }
  }
}

char *string_list_search(int slist, char *item)
{
  GList *dlist;
  char *string;

  for (dlist = global.string_list[slist]; dlist; dlist = dlist->next) {
    string = (char *) (dlist->data);
    if (!l_strcasecmp(string, item))
      return string;
  }
  return NULL;
}

GtkCList *string_list_get_clist(int slist)
{
  GtkCList *clist = NULL;

  switch (slist) {
  case LIST_IGNORE:
    clist = GTK_CLIST(lookup_widget(global.string_win, "clist24"));
    break;
  case LIST_FRIEND:
    clist = GTK_CLIST(lookup_widget(global.string_win, "clist23"));
    break;
  case LIST_ENEMY:
    clist = GTK_CLIST(lookup_widget(global.string_win, "clist25"));
    break;
  case LIST_HIGHLIGHT:
    clist = GTK_CLIST(lookup_widget(global.string_win, "clist30"));
    break;
  case LIST_OPCHANNEL:
    clist = GTK_CLIST(lookup_widget(global.string_win, "clist31"));
    break;
  case LIST_AUTOJOIN:
    clist = GTK_CLIST(lookup_widget(global.string_win, "clist32"));
    break;
  case LIST_NODOWNLOAD:
    clist = GTK_CLIST(lookup_widget(global.string_win, "clist33"));
    break;
  default:
    break;
  }
  return clist;
}

GtkEntry *string_list_get_entry(int slist)
{
  GtkEntry *entry = NULL;

  switch (slist) {
  case LIST_IGNORE:
    entry = GTK_ENTRY(lookup_widget(global.string_win, "entry112"));
    break;
  case LIST_FRIEND:
    entry = GTK_ENTRY(lookup_widget(global.string_win, "entry113"));
    break;
  case LIST_ENEMY:
    entry = GTK_ENTRY(lookup_widget(global.string_win, "entry114"));
    break;
  case LIST_HIGHLIGHT:
    entry = GTK_ENTRY(lookup_widget(global.string_win, "entry119"));
    break;
  case LIST_OPCHANNEL:
    entry = GTK_ENTRY(lookup_widget(global.string_win, "entry120"));
    break;
  case LIST_AUTOJOIN:
    entry = GTK_ENTRY(lookup_widget(global.string_win, "entry121"));
    break;
  case LIST_NODOWNLOAD:
    entry = GTK_ENTRY(lookup_widget(global.string_win, "entry126"));
    break;
  default:
    break;
  }
  return entry;
}

void string_list_add(int slist, char *item)
{
  GtkCList *clist;
  char *new_item;
  int row;
  chat_page_t* page;

  if (string_list_search(slist, item))
    return;

  new_item = l_strdup(item);
  global.string_list[slist] =
    g_list_append(global.string_list[slist], new_item);

  // do some action
  switch (slist) {
  case LIST_IGNORE:
    send_command(CMD_CLIENT_IGNORE_USER, item);
  case LIST_FRIEND:
  case LIST_ENEMY:
    update_user(item);
    break;
  case LIST_OPCHANNEL:
    channel_mode_activate(item, TRUE);
    page = chat_page_search(item, P_PUBLIC);
    if (page) gtk_paned_set_position(GTK_PANED(page->paned), 
				     global.paned_pos2);
    break;
  case LIST_HIGHLIGHT:
  case LIST_AUTOJOIN:
  case LIST_NODOWNLOAD:
  default:
    break;
  }

  // probably update list window
  if (!global.string_win) return;

  clist = string_list_get_clist(slist);
  if (clist) {
    strcpy(tstr[0], new_item);
    row = gtk_clist_append(clist, list);
    gtk_clist_set_row_data(clist, row, new_item);
  }
}

void string_list_remove(int slist, char *item)
{
  char *string;
  int row;
  GtkCList *clist;
  chat_page_t* page;

  string = string_list_search(slist, item);
  if (!string)
    return;

  global.string_list[slist] =
      g_list_remove(global.string_list[slist], string);

  // do some action
  switch (slist) {
  case LIST_IGNORE:
    send_command(CMD_CLIENT_UNIGNORE_USER, item);
  case LIST_FRIEND:
  case LIST_ENEMY:
    update_user(item);
    break;
  case LIST_OPCHANNEL:
    channel_mode_activate(item, FALSE);
    page = chat_page_search(item, P_PUBLIC);
    if (page) gtk_paned_set_position(GTK_PANED(page->paned), 0);
    break;
  case LIST_HIGHLIGHT:
  case LIST_AUTOJOIN:
  case LIST_NODOWNLOAD:
  default:
    break;
  }

  // probably update list window
  if (!global.string_win) {
    l_free(string);
    return;
  }

  clist = string_list_get_clist(slist);
  if (!clist)
    return;

  row = gtk_clist_find_row_from_data(clist, string);
  if (row >= 0) gtk_clist_remove(clist, row);
  l_free(string);
}

void highlight_add(char *item)
{
  string_list_add(LIST_HIGHLIGHT, item);
}
void highlight_remove(char *item)
{
  string_list_remove(LIST_HIGHLIGHT, item);
}
void friend_add(char *item)
{
  string_list_add(LIST_FRIEND, item);
}
void friend_remove(char *item)
{
  string_list_remove(LIST_FRIEND, item);
}
void enemy_add(char *item)
{
  string_list_add(LIST_ENEMY, item);
}
void enemy_remove(char *item)
{
  string_list_remove(LIST_ENEMY, item);
}
void ignore_add(char *item)
{
  string_list_add(LIST_IGNORE, item);
}
void ignore_remove(char *item)
{
  string_list_remove(LIST_IGNORE, item);
}
void opchannel_add(char *item)
{
  string_list_add(LIST_OPCHANNEL, item);
}
void opchannel_remove(char *item)
{
  string_list_remove(LIST_OPCHANNEL, item);
}
void autojoin_add(char *item)
{
  string_list_add(LIST_AUTOJOIN, item);
}
void autojoin_remove(char *item)
{
  string_list_remove(LIST_AUTOJOIN, item);
}
void nodownload_add(char *item)
{
  string_list_add(LIST_NODOWNLOAD, item);
}
void nodownload_remove(char *item)
{
  string_list_remove(LIST_NODOWNLOAD, item);
}
void on_item_remove_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkCList *clist;
  GList *row_list;
  char *string;
  int slist = (int) user_data;
  int row;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;

  while (row_list) {
    row = (int) row_list->data;
    row_list = row_list->next;
    string = (char *) gtk_clist_get_row_data(clist, row);
    if (string)
      string_list_remove(slist, string);
  }
}

GtkWidget *create_string_list_popup(int slist)
{
  GtkWidget *popup;
  GtkWidget *user_popup;
  GtkWidget *item;
  GtkAccelGroup *popup_accels;
  GtkWidget *separator;
  GtkCList *clist;
  char item_str[1024];
  int item_num;

  popup = gtk_menu_new();
  popup_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU(popup));
  clist = GTK_CLIST(global.popup_list);
  item_num = g_list_length(clist->selection);

  if (item_num < 2)
    item = gtk_menu_item_new_with_label(_("Remove Item"));
  else {
    sprintf(item_str, _("Remove Selected Items (%d)"), item_num);
    item = gtk_menu_item_new_with_label(item_str);
  }
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_item_remove_activate),
		     (void *) slist);

  if ((slist == LIST_FRIEND) || (slist == LIST_ENEMY)
      || (slist == LIST_IGNORE) || (slist == LIST_NODOWNLOAD)) {
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    item = gtk_menu_item_new_with_label(_("User Menu"));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);

    user_popup = create_user_popup(M_STRING_LIST);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), user_popup);
  }

  return popup;
}
