/* Copyright (C) 2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

typedef struct _ping_t ping_t;

struct _ping_t
{
  int input;
  char buf[2048];
  int pos;
  int pid;
  int fd;
  int cnt;

  time_t update;		// last try
  int time;			// time diff
  unsigned long ip_long;
  char *ip;
};

void ping_destroy(ping_t * ping);
ping_t *ping_search(unsigned long ip);
int ping_up_to_date(ping_t * ping);
void ping(unsigned long addr);
