/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"


void lt_setup(int argc, char **argv) {
	/* Get the cmdline options and set up the environment accordingly */
	lt_getopts(argc, argv);
	/* Initialize the regex stuff's */
	lt_regexinit();
}

void lt_run() {
	switch(outfmt) {

		case OUTPUT_RAW:
			lt_parse_raw();
			break;
		case OUTPUT_ANSI:
			lt_parse_ansi();
			break; 
		case OUTPUT_ASCII:
			lt_parse_ascii();
			break;
		case OUTPUT_CSV:
			lt_parse_csv();
			break;
		case OUTPUT_HTML:
			lt_parse_html();
			break;
		default:	/* we should never need this, but WTF, error checking is good, eh? */
			lt_sh_usage();
			exit(0);
			break;
	}
}

void lt_cleanup() {
	/* Ain't no cleanup to do at the moment.  If we ever need to though, we put it here */
}
