/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"

void lt_colorset_html() { /* this will set up the colors for the parseansi() function */

        /* 
         * determine if user asked us to "beep" on red events, and set up the value of
         * color.red accordingly. 
         */

	strncpy(color.red, "<FONT color=red>", 127);
        strncpy(color.green, "<FONT color=green>", 127);
        strncpy(color.yellow, "<FONT color=yellow>", 127);
        strncpy(color.white, "<FONT color=white>", 127);
        strncpy(color.cyan, "<FONT color=cyan>", 127);
        strncpy(color.brightcyan, "<FONT color=cyan>", 127);
        strncpy(color.unknown, "<FONT color=cyan>", 127);
	strncpy(color.end, "</FONT>", 127);
}



void lt_parse_html() {
	/* Set up the colors for ANSI output mode */
	lt_colorset_html();
	printf("<TABLE bgcolor=black><TR><TD>\n<PRE>\n");
	
	/* Open up stdin and read the input one line at a time till EOF */
	while(fgets(event.raw, 1024, stdin) != NULL) {
		/* Make sure the format of the input is correct */
		if(lt_fmtcheck(event.raw) != 1) {
			continue;
		}
	
		/* If we can parse up the line properly, then print it */	
		if (lt_do_parse() == TRUE) {

			/* Figure out what color (red/green/yellow) this message should be */
			lt_set_event_color();
			
			printf("%s", color.white);
			/* Do the timefmt stuff as a switch statement to give us more flex later */			
			switch(timefmt) {
				case DATE_SHORT:
					printf("%s", event.time);
					break;

				case DATE_LONG:
					printf("%s %s %s", event.month, event.day, event.time);
					break;

				default:
					printf("%s %s %s", event.month, event.day, event.time);
					
			}
			printf("%s", color.end);
			
			/* if we're supposed to print the source hostname of the event */
			if(showsrc == TRUE) {
				printf(" %s%s%s ", color.brightcyan, event.source, color.end);
			}

			/* If user didn't ask us not to display the program, then display it */
			if(showprog == TRUE) {
				printf(" %s%-16s%s ", color.cyan, event.program, color.end);
			}

			printf("%s", event.pcolor);
			/* Always print the message from the log event */
			printf(" %s%s\n", event.message, color.end);
			fflush(stdout);
		}
	}
	printf("</TABLE></PRE>\n");
}
