/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: settings.c,v 1.5 2002/01/29 04:51:25 martine Exp $
 */

#include "config.h"

#include <gtk/gtk.h>
#include <stdlib.h> /* atoi */

#include <libhalfgnome/halfgnome.h> 
#include <libhalfgnome/spawn.h> 

#include "dotconf.h"
#include "spell.h"
#include "util.h"

extern void lj_settings_changed(); /* tell main window a setting has changed. */

/* We make variables "global" like this, because there will always be only one
 * instance of the status window.  If this were C++, these would be members of
 * the statuswindow class.  We could make a struct to hold all of this... but
 * why? */

static config newconf;
static GtkWidget *settings_dlg;
static GtkWidget *eserver, *eproxyserver, *eproxyport;
#ifndef HAVE_GNOME
static GtkWidget *espawn;
#endif
static GtkWidget *espellcheck;

static void toggle_cb(GtkWidget *w, int* d) {
	*d = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
}

void proxy_cb(GtkWidget *w, GtkWidget *box) {
	gtk_widget_set_sensitive(box, !GTK_WIDGET_IS_SENSITIVE(box));
}

static GtkWidget* proxysettings() {
	GtkWidget *vbox, *hbox, *cb, *label;

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
		cb = gtk_check_button_new_with_label("Use proxy server");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), newconf.useproxy);
		gtk_signal_connect(GTK_OBJECT(cb), "toggled",
				GTK_SIGNAL_FUNC(toggle_cb), &newconf.useproxy);
	gtk_box_pack_start(GTK_BOX(vbox), cb, FALSE, FALSE, 0);
		hbox = gtk_hbox_new(FALSE, 5);
		gtk_widget_set_sensitive(hbox, newconf.useproxy);
			label = gtk_label_new("Address:");
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
			eproxyserver = gtk_entry_new();
			if (newconf.proxyserver) 
				gtk_entry_set_text(GTK_ENTRY(eproxyserver), newconf.proxyserver);
		gtk_box_pack_start(GTK_BOX(hbox), eproxyserver, TRUE, TRUE, 0);

			label = gtk_label_new("Port:");
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
			eproxyport = gtk_entry_new_with_max_length(5);
			gtk_widget_set_usize(eproxyport,
					gdk_string_width(eproxyport->style->font, "8080 "), -1);
			if (newconf.proxyport) {
				gchar *text = g_strdup_printf("%d", newconf.proxyport);
				gtk_entry_set_text(GTK_ENTRY(eproxyport), text);
				g_free(text);
			}
		gtk_box_pack_start(GTK_BOX(hbox), eproxyport, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			GTK_SIGNAL_FUNC(proxy_cb), hbox);
	/* note that the checkbox's "toggled" signal is connected to *two*
	 * functions.  fancy!
	 */

	return vbox;
}


static GtkWidget* networksettings() {
	GtkWidget *vbox;
	GtkWidget *frame;
	GtkWidget *hbox, *label;

	vbox = gtk_vbox_new(FALSE, 10); {
		gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);

		frame = gtk_frame_new("LiveJournal Server"); {
			hbox = gtk_hbox_new(FALSE, 5); {
				gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);

					label = gtk_label_new("Address:");
				gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
					eserver = gtk_entry_new();
					if (newconf.ljserver) 
						gtk_entry_set_text(GTK_ENTRY(eserver), newconf.ljserver);
				gtk_box_pack_start(GTK_BOX(hbox), eserver, TRUE, TRUE, 0);


				/* FIXME we don't support an alternative server anyway...
					label = gtk_label_new("Port:");
				gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
					port = gtk_entry_new_with_max_length(5);
					gtk_widget_set_usize(port,
							gdk_string_width(port->style->font, "8080 "), -1);
					if (newconf.port) {
						gchar *text = g_strdup_printf("%d", newconf.port);
						gtk_entry_set_text(GTK_ENTRY(port), text);
						g_free(text);
					}
				gtk_box_pack_start(GTK_BOX(hbox), port, FALSE, FALSE, 0);*/
			}
			gtk_container_add(GTK_CONTAINER(frame), hbox);
		}
		gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

		frame = gtk_frame_new("HTTP Proxy");
		gtk_container_add(GTK_CONTAINER(frame), proxysettings());
		gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	}

	return vbox;
}

static void sec_public_cb(GtkWidget *w, SecurityType *sec) {
	*sec = SECURITY_PUBLIC;
}
static void sec_private_cb(GtkWidget *w, SecurityType *sec) {
	*sec = SECURITY_PRIVATE;
}
static void sec_friends_cb(GtkWidget *w, SecurityType *sec) {
	*sec = SECURITY_FRIENDS;
}

static GtkWidget* uisettings() {
	GtkWidget *vbox, *cb;

	vbox = gtk_vbox_new(FALSE, 5); {
		GtkWidget *hbox;

		gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);

		cb = gtk_check_button_new_with_label("Confirm when deleting (entries, friend groups)");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), newconf.confirmdelete);
		gtk_signal_connect(GTK_OBJECT(cb), "toggled",
				GTK_SIGNAL_FUNC(toggle_cb), &newconf.confirmdelete);
		gtk_box_pack_start(GTK_BOX(vbox), cb, FALSE, FALSE, 0);

		cb = gtk_check_button_new_with_label("Automatically revert to primary journal\nafter posting on a shared journal");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), newconf.revertusejournalafterpost);
		gtk_signal_connect(GTK_OBJECT(cb), "toggled",
				GTK_SIGNAL_FUNC(toggle_cb), &newconf.revertusejournalafterpost);
		gtk_box_pack_start(GTK_BOX(vbox), cb, FALSE, FALSE, 0);

		cb = gtk_check_button_new_with_label("Keep metadata after posting");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), newconf.savemetadata);
		gtk_signal_connect(GTK_OBJECT(cb), "toggled",
				GTK_SIGNAL_FUNC(toggle_cb), &newconf.savemetadata);
		gtk_box_pack_start(GTK_BOX(vbox), cb, FALSE, FALSE, 0);

		hbox = gtk_hbox_new(FALSE, 5); {
			GtkWidget *omenu, *menu, *item;

			gtk_box_pack_start(GTK_BOX(hbox), 
					gtk_label_new("Default security on posts:"),
					FALSE, FALSE, 0);
			
			menu = gtk_menu_new(); {
				item = gtk_menu_item_new_with_label("Public");
				gtk_signal_connect(GTK_OBJECT(item), "activate",
						GTK_SIGNAL_FUNC(sec_public_cb), &newconf.defaultsecurity);
				gtk_menu_append(GTK_MENU(menu), item);

				item = gtk_menu_item_new_with_label("Private");
				gtk_signal_connect(GTK_OBJECT(item), "activate",
						GTK_SIGNAL_FUNC(sec_private_cb), &newconf.defaultsecurity);
				gtk_menu_append(GTK_MENU(menu), item);

				item = gtk_menu_item_new_with_label("Friends-Only");
				gtk_signal_connect(GTK_OBJECT(item), "activate",
						GTK_SIGNAL_FUNC(sec_friends_cb), &newconf.defaultsecurity);
				gtk_menu_append(GTK_MENU(menu), item);
			}
			omenu = gtk_option_menu_new();
			gtk_option_menu_set_menu(GTK_OPTION_MENU(omenu), menu);
			gtk_option_menu_set_history(GTK_OPTION_MENU(omenu), 
					newconf.defaultsecurity);
			gtk_box_pack_start(GTK_BOX(hbox), omenu, TRUE, TRUE, 0);
		}

		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	}

	return vbox;
}

#ifndef HAVE_GNOME
static GtkWidget* websettings() {
	GtkWidget *vbox;
	GtkWidget *combo, *label;
	GList *list = NULL;

	vbox = gtk_vbox_new(FALSE, 5); {
		int i;
		list = NULL;

		gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);

		label = gtk_label_new(
				"This command is evaluated by /bin/sh.\n"
				"Use %s in the command line in the place of the URL.\n"
				"You can use %s more than once.");
		gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
		gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
		gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

		for (i = 0; halfgnome_spawn_commands[i] != NULL; i++) {
			list = g_list_append(list, halfgnome_spawn_commands[i]);
		}

			label = gtk_label_new("Command:");
			gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
		gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

			combo = gtk_combo_new();
			gtk_combo_set_popdown_strings(GTK_COMBO(combo), list);
			espawn = GTK_COMBO(combo)->entry;
			if (halfgnome_spawn_get_command()) 
				gtk_entry_set_text(GTK_ENTRY(espawn), 
						halfgnome_spawn_get_command());
		gtk_box_pack_start(GTK_BOX(vbox), combo, FALSE, FALSE, 0);
	}
	return vbox;
}
#endif /* HAVE_GNOME */

void spellcheck_toggle_cb(GtkWidget *w, gpointer d) {
	gtk_widget_set_sensitive(GTK_WIDGET(d), newconf.usespellcheck);
}


GtkWidget* spellsettings() {
	GtkWidget *vbox;
	GtkWidget *cb;
	GtkWidget *combo, *label;

	vbox = gtk_vbox_new(FALSE, 5); {
		GtkWidget *hbox;

		gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);

		label = gtk_label_new("Please note that this is somewhat unstable.");
		gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
		gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

		cb = gtk_check_button_new_with_label("Enable spell checking");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), newconf.usespellcheck);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), newconf.usespellcheck);
		gtk_signal_connect(GTK_OBJECT(cb), "toggled",
				GTK_SIGNAL_FUNC(toggle_cb), &newconf.usespellcheck);
		gtk_box_pack_start(GTK_BOX(vbox), cb, FALSE, FALSE, 0);

		label = gtk_label_new(
				"This program must have an ispell-compatible interface,\n"
				"and the command must include the flag (-a for ispell)\n"
				"to run it in the embedded mode.\n"
				"Also, this command is *not* evaluated by the shell.");
		gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
		gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
		gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

		hbox = gtk_hbox_new(FALSE, 5); {
			int i;
			GList *list = NULL;
			char *spellcmds[] = {
				"ispell -a -P",
				"aspell pipe --sug-mode=fast",
				NULL
			};

			for (i = 0; spellcmds[i] != NULL; i++) {
				list = g_list_append(list, spellcmds[i]);
			}

				label = gtk_label_new("Command:");
			gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
				combo = gtk_combo_new();
				gtk_combo_set_popdown_strings(GTK_COMBO(combo), list);
				espellcheck = GTK_COMBO(combo)->entry;
				if (newconf.spellcheck) 
					gtk_entry_set_text(GTK_ENTRY(espellcheck), newconf.spellcheck);
			gtk_box_pack_start(GTK_BOX(hbox), combo, TRUE, TRUE, 0);
		}
		gtk_widget_set_sensitive(hbox, newconf.usespellcheck);
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

		gtk_signal_connect(GTK_OBJECT(cb), "toggled",
				GTK_SIGNAL_FUNC(spellcheck_toggle_cb), hbox);
	}
	return vbox;
}

static GtkWidget* debugsettings() {
	GtkWidget *vbox, *cb;

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);
		cb = gtk_check_button_new_with_label("Dump network data on stdout");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), newconf.netdump);
		gtk_signal_connect(GTK_OBJECT(cb), "toggled",
				GTK_SIGNAL_FUNC(toggle_cb), &newconf.netdump);
	gtk_box_pack_start(GTK_BOX(vbox), cb, FALSE, FALSE, 0);
		cb = gtk_check_button_new_with_label("Don't use threads on network requests");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), newconf.nothread);
		gtk_signal_connect(GTK_OBJECT(cb), "toggled",
				GTK_SIGNAL_FUNC(toggle_cb), &newconf.nothread);
	gtk_box_pack_start(GTK_BOX(vbox), cb, FALSE, FALSE, 0);

	return vbox;
}

static void convert_none_cb(GtkWidget *w, int *convert) {
	*convert = CONVERT_NONE;
}

static void convert_koi2win_cb(GtkWidget *w, int *convert) {
	*convert = CONVERT_KOI2WIN;
}

static GtkWidget* convertsettings() {
	GtkWidget *vbox, *label;

	vbox = gtk_vbox_new(FALSE, 5);
	label = gtk_label_new("LogJam can automatically convert\n"
			"the character set of outgoing and incoming data.\n"
			"This is currently only useful if you're Russian. :)");
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

	gtk_container_set_border_width(GTK_CONTAINER(vbox), 10); {
		GtkWidget *hbox;

		hbox = gtk_hbox_new(FALSE, 5); {
			GtkWidget *omenu, *menu, *item;

			gtk_box_pack_start(GTK_BOX(hbox), 
					gtk_label_new("Character translation:"),
					FALSE, FALSE, 0);

			menu = gtk_menu_new(); {
				item = gtk_menu_item_new_with_label("None");
				gtk_signal_connect(GTK_OBJECT(item), "activate",
						GTK_SIGNAL_FUNC(convert_none_cb), 
						&newconf.convertcharset);
				gtk_menu_append(GTK_MENU(menu), item);

				item = gtk_menu_item_new_with_label("KOI -> WIN");
				gtk_signal_connect(GTK_OBJECT(item), "activate",
							 GTK_SIGNAL_FUNC(convert_koi2win_cb),
							 &newconf.convertcharset);
				gtk_menu_append(GTK_MENU(menu), item);
			}
			omenu = gtk_option_menu_new();
			gtk_option_menu_set_menu(GTK_OPTION_MENU(omenu), menu);
			gtk_option_menu_set_history(GTK_OPTION_MENU(omenu), 
					newconf.convertcharset);
			gtk_box_pack_start(GTK_BOX(hbox), omenu, TRUE, TRUE, 0);
		}
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	}

	return vbox;
}

void ok_cb(GtkWidget *w, GtkWidget *dlg) {
	int lastofs;
	if (newconf.ljserver)
		g_free(newconf.ljserver);
	newconf.ljserver = gtk_editable_get_chars(GTK_EDITABLE(eserver), 0, -1);

	/* make sure it doesn't end with a slash. */
	lastofs = strlen(newconf.ljserver)-1;
	if (newconf.ljserver[lastofs] == '/')
		newconf.ljserver[lastofs] = 0;

	if (newconf.useproxy) {
		gchar *text;
		text = gtk_editable_get_chars(GTK_EDITABLE(eproxyport), 0, -1);
		newconf.proxyport = atoi(text);
		g_free(text);
		if (newconf.proxyserver) g_free(newconf.proxyserver);
		newconf.proxyserver = 
			gtk_editable_get_chars(GTK_EDITABLE(eproxyserver), 0, -1);
	}

#ifndef HAVE_GNOME
	{
	char *text;
	text = gtk_editable_get_chars(GTK_EDITABLE(espawn), 0, -1);
	halfgnome_spawn_set_command(text);
	g_free(text);
	}
#endif

	if (newconf.spellcheck) g_free(newconf.spellcheck);
	newconf.spellcheck = gtk_editable_get_chars(GTK_EDITABLE(espellcheck), 0, -1);
			
	memcpy(&conf, &newconf, sizeof(config));
	gtk_widget_destroy(dlg);
}

void settings_dialog(GtkWidget *mainwin) {
	GtkWidget *dlg, *nb;

	memcpy(&newconf, &conf, sizeof(config));
	
	settings_dlg = dlg = lj_dialog_new(mainwin, "Settings", -1, -1);
	gtk_signal_connect(GTK_OBJECT(dlg), "destroy",
			GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_window_set_policy(GTK_WINDOW(dlg), FALSE, FALSE, TRUE); 
	/* non-resizable */

	nb = gtk_notebook_new();
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), 
			uisettings(), gtk_label_new("User Interface"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), 
			spellsettings(), gtk_label_new("Spell Check"));
#ifndef HAVE_GNOME
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), 
			websettings(), gtk_label_new("Web"));
#endif
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), 
			networksettings(), gtk_label_new("Network"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb),
			convertsettings(), gtk_label_new("Convert"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), 
			debugsettings(), gtk_label_new("Debug"));

	lj_dialog_set_contents(dlg, nb);
	gtk_widget_show_all(GTK_DIALOG(dlg)->vbox);

	lj_dialog_add_okcancel(dlg, NULL, GTK_SIGNAL_FUNC(ok_cb), dlg);
	gtk_widget_show(dlg);
	gtk_main();
}

