/* LogJam, a GTK LiveJournal client.
 * Copyright (C) 2000,2001 Evan Martin <evan@livejournal.com>
 * vim:ts=4:sw=4:
 *
 * $Id: about.c,v 1.3 2001/11/07 02:03:37 martine Exp $
 */

#include "config.h"

#include <gtk/gtk.h>

#include <libhalfgnome/halfgnome.h>

#include "../pixmaps/goat.xpm"
#include "gtkspell.h"
#include "util.h"

typedef struct {
	char *name; 
	char *website;
	char *ljname;
} infoz;

char**
get_goat_xpm() {
	return goat_xpm;
}

static GtkWidget*
make_title_box(GtkWidget *win) {
	GtkWidget *hbox, *vbox;
	GdkPixmap *pix; GdkBitmap *bit;
	GtkWidget *pixmap, *label, *url;

	pix = gdk_pixmap_colormap_create_from_xpm_d(win->window, 
			NULL, &bit, NULL, goat_xpm);
	pixmap = gtk_pixmap_new(pix, bit);
	
	label = gtk_label_new(PROGRAMNAME " " VERSION "\nCopyright (C) 2000,2001 Evan Martin");

	url = halfgnome_href_new("http://loserjabber.sourceforge.net", 
			"Website");

	vbox = gtk_vbox_new(FALSE, 0); 
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), url, FALSE, FALSE, 0);

	hbox = gtk_hbox_new(FALSE, 10); 
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

	return hbox;
}

static GtkWidget*
make_xmms_box() {
	GtkWidget *hbox;

	hbox = gtk_hbox_new(FALSE, 5); 

	gtk_box_pack_start(GTK_BOX(hbox), 
			gtk_label_new("Written with"),
			FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(hbox),
			halfgnome_href_new("http://www.xmms.org", "XMMS"),
			FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), 
			gtk_label_new("support."),
			FALSE, FALSE, 0);

	return hbox;
}

static GtkWidget*
make_gtkspell_box() {
	GtkWidget *hbox;

	hbox = gtk_hbox_new(FALSE, 5); 

	gtk_box_pack_start(GTK_BOX(hbox), 
			gtk_label_new("Using"),
			FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox),
			halfgnome_href_new("http://gtkspell.sourceforge.net", 
				"GtkSpell " GTKSPELL_VERSION),
			FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), 
			gtk_label_new("."),
			FALSE, FALSE, 0);

	return hbox;
}

#ifdef HAVE_GNOME
static GtkWidget*
make_gnome_box() {
	GtkWidget *hbox;

	hbox = gtk_hbox_new(FALSE, 5); 
	gtk_box_pack_start(GTK_BOX(hbox), 
			gtk_label_new("Compiled with"),
			FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox),
			halfgnome_href_new("http://www.gnome.org", 
				"GNOME"),
			FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), 
			gtk_label_new("support."),
			FALSE, FALSE, 0);
	return hbox;
}
#endif

static GtkWidget*
make_author_box() {
	GtkWidget *vbox, *hbox, *label;

	vbox = gtk_vbox_new(FALSE, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new("Written by"),
			FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), halfgnome_href_new("http://evan.livejournal.com", "Evan Martin"),
			FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new(","),
			FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

	label = gtk_label_new("(with help from many contributors\nlisted in the README).");
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);

	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
	return vbox;
}

void about_dlg(GtkWidget *mainwin) {
	GtkWidget *dlg, *mainbox;

	dlg = lj_dialog_new(mainwin, "About " PROGRAMNAME, -1, -1);

	/* make the bounding padding box */
	mainbox = gtk_vbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(mainbox), make_title_box(mainwin), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mainbox), make_xmms_box(), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mainbox), make_gtkspell_box(), FALSE, FALSE, 0);
#ifdef HAVE_GNOME
	gtk_box_pack_start(GTK_BOX(mainbox), make_gnome_box(), FALSE, FALSE, 0);
#endif /* HAVE_GNOME */
	gtk_box_pack_start(GTK_BOX(mainbox), make_author_box(), FALSE, FALSE, 0);

	lj_dialog_set_contents(dlg, mainbox);
	lj_dialog_add_close(dlg);

	gtk_widget_show(dlg);
}

