#!/usr/bin/perl
#
# copyfile.pl: commonly used routine to keep a logfile.
#
use strict;
use warnings;

require '/usr/lib/localization-config/common/log.pl';

sub copyfile {    
    my ($from, $to) = @_;
    log_msg("$0:copyfile(): copying $from -> $to");
    
    open(FROM, "$from");            # Open the file
    open(TO, ">$to");               # Open the file
    my @lines = <FROM>;             # Read it into an array
    print TO @lines;                # Print the array
    close(TO);                      # Close the dest file
    close(FROM);                    # Close the source file
    
    return 1;
}

1;