/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandIndexOpen: public LWCommandSegment {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	
	g_return_val_if_fail (argc == 2, new LWValue());
	
	gint index = args[1]->toInt();

	if (FALSE == args[0]->canBeIndexed())
		throw new LWMessage (LW_ERROR_IsNotArray);
	
	if (index <= 0)
		throw new LWMessage (LW_ERROR_BadIndexOfArray);
	
	if (index > 65535)
		throw new LWMessage (LW_ERROR_IndexOutOfRange);
		
	LWValue *v = args[0]->getIndex (index);
	
	if (v == NULL)
		throw new LWMessage (LW_ERROR_IndexOutOfRange);
	
	return v;
}

const gchar *getName ()
{
	return "[";
}	

gchar *getHint ()
{
	return _("Index of array");
}

guint getPriority ()
{
	return 14;
}

LWLink getLinkType ()
{
	return LW_LINK_LEFT;
}

gboolean hasReturn()
{
	return TRUE;
}

gboolean matchNextCondition (LWCommand *cmd)
{
	(void) cmd;
	return TRUE;
}

gboolean matchWith (LWCommand *cmd)
{
	if (cmd == NULL)
		throw new LWMessage (LW_ERROR_UnmatchedBrace);

	if (cmd->getName()[0] != ']')
		throw new LWMessage (LW_ERROR_UnmatchedBrace);
	
	match();
	
	return TRUE;
}

void checkArgc (guint n)
{
	if (n != 2) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}	

void checkArgument (guint n, LWValue *value)
{
	if (n == 1)
		if (FALSE == value->isVariable())
			if (0 >= value->toInt())
				throw new LWMessage (LW_ERROR_BadIndexOfArray);
}

};

LWSymbol *new_LWCommandIndexOpen()
{
	return new LWCommandIndexOpen();
}
