package Lire::Extensions::WWW::CountrySchema;

# vim:syntax=perl

use strict;

use vars qw( $VERSION @ISA );

use Lire::AsciiDlf::ExtendedFieldsCreator;

use Lire::WWW::Domain;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.2 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::AsciiDlf::ExtendedFieldsCreator );
}

sub init_computation {
    my ( $self ) = @_;

    $self->{analyzer} = new Lire::WWW::Domain;

    # Cache field's index
    $self->{domain_idx} = $self->schema->field( "client_domain" )->pos;
}

sub create_extended_fields {
    my ( $self, $dlf ) = @_;

    my $domain = $dlf->[$self->{domain_idx} ];
    if ( $domain eq "LIRE_NOTAVAIL" ) {
	return ["LIRE_NOTAVAIL" ];
    } elsif ($domain =~ /^\d*\.\d*/) {
	# We do not return LIRE_NOTAVAIL here, because
	# we can't set a LIRE_NOTAVAIL on per record basis. All the
	# the records should have LIRE_NOTAVAIL for a specific fields or
	# none should
	return [ "Unknown" ];
    } else {
	$self->{analyzer}->setDomain($domain);
	return [ $self->{analyzer}->getCountry() || "n/a" ];
    }
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Extensions::WWW::CountrySchema -

=head1 SYNOPSIS

=head1 DESCRIPTION

Interface to the Lire::WWW::Domain package.

=head1 VERSION

$Id: CountrySchema.pm,v 1.2 2002/01/19 18:20:06 vanbaal Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

E.L. Willighagen <egonw@logreport.org>

=cut
