package Lire::Extensions::Email::EmailSchema;

# vim:syntax=perl

use strict;

use vars qw( $VERSION @ISA );

use Lire::AsciiDlf::ExtendedFieldsCreator;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.1 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::AsciiDlf::ExtendedFieldsCreator );
}

sub init_computation {
    my ( $self ) = @_;

    # Cache the fields' index
    $self->{from_domain_idx}= $self->schema->field( "from_domain" )->pos;
    $self->{from_user_idx}  = $self->schema->field( "from_user" )->pos;
    $self->{to_domain_idx}  = $self->schema->field( "to_domain" )->pos;
    $self->{to_user_idx}    = $self->schema->field( "to_user" )->pos;
}

sub create_extended_fields {
    my ( $self, $dlf ) = @_;

    my $from_email  = $dlf->[$self->{from_user_idx}] . '@' .
      $dlf->[$self->{from_domain_idx}];
    my $to_email    = $dlf->[$self->{to_user_idx}] . '@' .
      $dlf->[$self->{to_domain_idx}];

    return [ $from_email, $to_email ];
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::EmailSchema -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: EmailSchema.pm,v 1.1 2001/09/24 02:22:10 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
