<?xml version="1.0" encoding="US-ASCII"?>

<!-- $Id: lire-desc.mod,v 1.5 2001/11/21 00:29:21 flacoste Exp $ -->

<!--

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
     
You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

-->

<!-- 
    This module defines the elements related to human descriptions
    in all Lire DTDs.

    This module imports DocBook XML V4.1.2 for richer semantic 
    tagging.

    This module is also namespace aware and will honor the
    setting of LIRE.pfx to scope its element

    In DTD driver files referring to this module, please use an entity
    declaration that uses the public identifier shown below:

    &lt;!ENTITY % lire-desc.mod PUBLIC
    "-//LogReport.ORG//ELEMENTS Lire Description Elements V1.0//EN">
    %lire-desc.mod;
                                                                   -->

<!--
    Make sure LIRE.pfx is defined. This declaration will be
    ignored if it was already defined.
                                                                   -->
<!ENTITY % LIRE.pfx          "lire:"                                 >
<!ENTITY % xml-lang.attr     "xml:lang NMTOKEN #IMPLIED"             >

<!ENTITY % LIRE.title        "%LIRE.pfx;title"                       >
<!ENTITY % LIRE.description  "%LIRE.pfx;description"                 >

<!ENTITY % target-user.enum  "sysadmin | manager"                    >
<!ENTITY % userlevel.enum    "normal | advanced"                     >
<!ENTITY % userlevel.default "normal"                                >


<!--
    Parameter entity that controls the loading of the DocBook XML DTD.
    This can be turn off for performance issues.
                                                                   -->
<!ENTITY % load.docbookx     "INCLUDE"                               >
<!--     
    Title element.

    The title element contains a descriptive title. 

    This element represent some title in Lire. It can be
    used to give a title to a report specification or to
    specifify the title of a report or subreport.

    The content of this element should be localized.
    
    Attribute of title:
        xml:lang:       The language of that title.
                                                                   -->

<!ELEMENT %LIRE.title; (#PCDATA)                                     >
<!ATTLIST %LIRE.title;
             %xml-lang.attr;                                         >

<!--     
    Description element.

    The description element is used to describe an element. It can
    be used to descrie DLF fields, describe a report specification 
    or include descriptions in the generated reports.

    This element contains any number of DocBook paragraph elements.

    The content of this element should be localized.
    
    Attribute of description:
        xml:lang:       The language of that description.
        userlevel:      Specify the userlevel for which this 
                        description is appropriate.
                                                                   -->
<![%load.docbookx;[
<!ENTITY % define.desc       "IGNORE"                                >
<!ELEMENT %LIRE.description; (para+)                                 >
]]>

<!-- Define description another way if we aren't going to include 
     DocBook XML                                                   -->
<!ENTITY % define.desc       "INCLUDE"                               >
<![%define.desc;[
<!ELEMENT %LIRE.description; (ANY+)                                  >
]]>

<!ATTLIST %LIRE.description;
             %xml-lang.attr;
             target-user ( %target-user.enum; )            #IMPLIED  >

<!-- =============================================================
                        DocBook Customization
     ============================================================= 

                                                                   -->
<![%load.docbookx;[
<!ENTITY % DocBookDTD PUBLIC
  "-//OASIS//DTD DocBook XML V4.1.2//EN"
  "http://www.oasis-open.org/docbook/xml/4.1.2/docbookx.dtd">
%DocBookDTD;
]]>
