#
# $Id: Attack.pm,v 1.6 2002/01/19 18:20:05 vanbaal Exp $
#
# Copyright (C) 2001 LogReport Foundation LogReport@LogReport.org
#
#     This file is part of Lire.
#
#     Lire is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program (see COPYING); if not, check with
#     http://www.gnu.org/copyleft/gpl.html or write to the Free Software
#     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
#
package Lire::WWW::Filename::Attack;

use strict;
use vars qw/ $REVISION/;

{
    $REVISION  = '$Id: Attack.pm,v 1.6 2002/01/19 18:20:05 vanbaal Exp $';
}

# -----------------------------------------------------------------------------
# Database
# -----------------------------------------------------------------------------

my %AttackHash = (
  # attacks on IIS servers
  # this sucks... this could be done much better!
  # Nimda, for example, uses several exploits, of which
  # the Code Red II Back Door attack...
  "/default.ida" => "Code Red",
  "/msadc/msadcs.dll" => "MDAC Attack",
  "asp+.htr" => ".htr Exploit",
  "asa+.htr" => ".htr Exploit",
  "/scripts/root.exe?/c+dir" => "Code Red II Back Door Attack",
  "/msadc/root.exe?/c+dir" => "Code Red II Back Door Attack",
  "/scripts/..%255c../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/_vti_bin/..%255c../..%255c../..%255c../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/_mem_bin/..%255c../..%255c../..%255c../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/msadc/..%255c../..%255c../..%255c../..%c1%1c../..%c1%1c../..%/winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/msadc/..%255c../..%255c../..%255c/..%c1%1c../..%c1%1c../..%c1%1c../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/scripts/..%c1%1c../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/scripts/..%c0%2f../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/scripts/..%c0%af../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/scripts/..%c1%9c../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/scripts/..%%35%63../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/scripts/..%%35c../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/scripts/..%25%35%63../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/scripts/..%252f../winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/c/winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
  "/d/winnt/system32/cmd.exe?/c+dir" => "Nimda Worm",
);

my %CompiledHash = map { $_ => qr/$_/; } keys %AttackHash;

# -----------------------------------------------------------------------------
# Functions
# -----------------------------------------------------------------------------

sub getAttack {
    my ( $filename ) = @_;

    foreach my $attack (keys %AttackHash) {
        # i guess some escaping is in order
        my $enc_attack = $attack;
        $enc_attack =~ s/(\W)/\\$1/g;
        # print "<-- Matching $filename =~ $enc_attack; ";
        if ($filename =~ /$enc_attack/i) {
            # print "MATCH! -->\n";
            return $AttackHash{$attack};
        }
        # print "-->\n";
    }
    return undef;
}

1;

