package Lire::XMLUtils;

use strict;

use vars qw( $VERSION @ISA @EXPORT_OK );

BEGIN {
    ($VERSION)	= '$Revision: 1.1 $' =~ m!Revision: ([.\d]+)!;

    require Exporter;
    @ISA	= qw/Exporter/;
    @EXPORT_OK	= qw/xml_encode/;
}

sub xml_encode {
    my $value = $_[0];

    $value =~ s/&/&amp;/g;
    $value =~ s/</&lt;/g;
    $value =~ s/"/&quot;/g;
    $value =~ s/'/&apos;/g;

    return $value;
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::XMLUtils - Collection of useful functions when processing XML files.

=head1 SYNOPSIS

use Lire::XMLUtils qw/xml_encode/;

=head1 DESCRIPTION

Lire::XMLUtils contains useful functions when processing or writing 
XML files. 

No functions are exported by default, you have to specify the one you
want to import in your namespace when you use the module.

The defined functions are:

=over 4

=item xml_encode

Converts standard the characters <,>,&," and ' to their XML entities.

Use like this

    print XML_STREAM xml_encode( $value );

=back

=head1 VERSION

$Id: XMLUtils.pm,v 1.1 2002/01/16 20:21:16 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
