package Lire::AsciiDlf::ReportSpec;

use strict;

use vars qw( $VERSION @ISA );

use Lire::ReportSpec;

use Carp;

use constant INITED	=> 1;
use constant FINISHED	=> 2;

BEGIN {
    ($VERSION)	= '$Revision: 1.8 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::ReportSpec );
}

sub init_report {
    my $self = shift;
    my %args = @_;

    if (exists $args{params} ) {
	# Set parameters
	while ( my ($name, $value) = each %{$args{params}}) {
	    $self->param( $name )->value( $value );
	}
    }

    if ( $self->extension ) {
	$self->{_calc} = $self->extension;
    } else {
	$self->{_calc} = $self->calc_spec;
    }
    $self->{_calc}->init_report( @_ );
    $self->{_state} = INITED;

    $self;
}

sub update_report {
    my ($self, $dlf ) = @_;

    croak "init_report() wasn't called"
      unless $self->{_state} == INITED;

    $self->{_calc}->update_report( $dlf );

    $self;
}

sub end_report {
    my $self = shift;

    croak "init_report() wasn't called"
      unless $self->{_state} == INITED;

    $self->{_state} = FINISHED;
    $self->{_calc}->end_report( @_ );

    $self;
}


sub write_report {
    my ( $self, $fh, $prefix ) = @_;
    $fh	    ||= \*STDOUT;
    $prefix ||= 0;

    my $pfx	= ' ' x $prefix;
    my $super	= $self->superservice;
    my $date	= time;
    my $chart	= $self->charttype;
    my $type	= $self->id;

    print $fh qq{$pfx<lire:subreport type="$type" superservice="$super" date="$date">\n};
    print $fh $pfx, '<lire:title>', $self->expanded_display_title(),
      "</lire:title>\n\n";

    foreach my $u ( $self->target_users ) {
	print $fh $pfx, '<lire:description';
	print $fh qq{ target-user="$u"}
	  if defined $u;
	print $fh ">";
	print $fh $self->expanded_display_description( $u ),
	  "</lire:description>\n\n";
    }
    print $fh qq{$pfx <lire:table};
    print $fh qq{ charttype="$chart"} if defined $chart;
    print $fh ">\n";

    $self->{_calc}->write_report( $fh, $prefix + 2 );

    print $fh $pfx, " </lire:table>\n";
    print $fh $pfx, "</lire:subreport>\n\n";

    $self;
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::AsciiDlf::Group -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: ReportSpec.pm,v 1.8 2001/12/13 21:08:17 vanbaal Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut


