package Lire::Config::Build;

use strict;

require Exporter;

use vars qw( $VERSION %ac @ISA @EXPORT_OK );

sub coalesce {
    my $x;
    $x = shift while @_ && !defined $x;
    return $x;
}

BEGIN {
    ($VERSION)  = '$Revision: 1.9 $' =~ m!Revision: ([.\d]+)!;

    @ISA = qw(Exporter);
    @EXPORT_OK  = qw(ac_info ac_path ac_flags);

    %ac = (
        exec_prefix => '${prefix}',
        prefix => '/usr/local',
        program_transform_name => 's,x,x,',
        bindir => '${exec_prefix}/bin',
        sbindir => '${exec_prefix}/sbin',
        libexecdir => '${exec_prefix}/libexec',
        datadir => '${prefix}/share',
        sysconfdir => '${prefix}/etc',
        sharedstatedir => '${prefix}/com',
        localstatedir => '${prefix}/var',
        libdir => '${exec_prefix}/lib',
        includedir => '${prefix}/include',
        oldincludedir => '/usr/include',
        infodir => '${prefix}/share/info',
        mandir => '${prefix}/share/man',
        INSTALL_PROGRAM => '${INSTALL}',
        INSTALL_SCRIPT => '${INSTALL}',
        INSTALL_DATA => '${INSTALL} -m 644',
        PACKAGE => 'lire',
        VERSION => '2.1.1',
        SHELL => '/bin/bash',
        CFLAGS => '@CFLAGS@',
        CPPFLAGS => '@CPPFLAGS@',
        CXXFLAGS => '@CXXFLAGS@',
        FFLAGS => '@FFLAGS@',
        DEFS => '-DPACKAGE_NAME=\"\" -DPACKAGE_TARNAME=\"\" -DPACKAGE_VERSION=\"\" -DPACKAGE_STRING=\"\" -DPACKAGE_BUGREPORT=\"\" -DPACKAGE_URL=\"\" -DPACKAGE=\"lire\" -DVERSION=\"2.1.1\"',
        LDFLAGS => '@LDFLAGS@',
        LIBS => '',
        PERL => '/usr/bin/perl',
        LR_PERL5LIB => '/usr/local/share/perl5',
        GZIP => '/bin/gzip',
        SENDMAIL => '/usr/sbin/sendmail',
        PLOTICUS => '/usr/bin/ploticus',
        TAR => '/bin/tar',
        GHOSTSCRIPT => '/usr/bin/gs',
        LR_ARCHIVEDIR => '/usr/local/var/lib/lire/data',
    );
    # calculate the transitive closure of any substitutions
    my $changed;
    do {
        $changed = 0;
        while(my ($k, $v) = each(%ac)) {
            $changed ||= $ac{$k} =~ s/\$\{([^}]+)\}/coalesce($ac{$1}, $ENV{$1}, '')/e;
            $changed ||= $ac{$k} =~ s/\$([A-Za-z][A-Za-z0-9_]*)/coalesce($ac{$1}, $ENV{$1}, '')/e;
        }
    } while($changed);
}

sub ac_info {
    return $ac{$_[0]};
}

sub ac_path {
    return join('/', map { ac_info($_) } @_);
}

sub ac_flags {
    return join(' ', map { ac_info($_) } @_);
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Config::Build - Look up build-time information

=head1 SYNOPSIS

This module provides build-time information to the configuration
module. It is primarily intended to be used internally by the
configuration module but can be used elsewhere as well. Consider
using the proper configuration though, since the user may wish to
override certain parameters.

=head1 DESCRIPTION

=head1 VERSION

$Id: Build.pm.in,v 1.9 2011/11/15 16:33:00 wraay Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html. 

=head1 AUTHOR

Wessel Dankers <wsl@logreport.org>

=cut
# Local Variables:
# mode: cperl
# End:
