package Lire::FilterSpec;

use strict;

use base qw/ Lire::XMLSpecContainer /;

use Lire::Config;
use Lire::Utils qw/check_object_param/;

=pod

=head1 NAME

Lire::FilterSpec - Global filter specification.

=head1 SYNOPSIS

    use Lire::FilterSpec;

=head1 DESCRIPTION

=head1 META INFORMATION METHODS

=head2 list_specs( $superservice )

Returns an array reference containing all the filter specification
type available for the $superservice superservice.

=head2 has_spec( $superservice, $type )

Returns true if there is a $type specification available for the
$superservice.

=cut

########################################################################
#			 Lire::XMLSpecContainer METHODS
########################################################################

sub root_element {
    my ( $self ) = @_;

    return "global-filter-spec";
}

sub spec_path {
    return Lire::Config->get( 'lr_filters_path' );
}

sub print_children {
    my ( $self, $fh, $indent ) = @_;

    my $pfx = ' ' x $indent;
    print $fh "$pfx<lire:filter-spec>\n";
    $self->{'filter_spec'}->print( $fh, $indent + 1);
    print $fh "\n$pfx</lire:filter-spec>\n\n";

    return;
}

########################################################################
#			 Lire::FilterSpec METHODS
########################################################################

sub filter_spec {
    my ( $self, $filter_spec ) = @_;

    if ( @_ == 2 ) {
        check_object_param( $filter_spec, 'filter_spec', 'Lire::FilterExpr' );
	$self->{'filter_spec'} = $filter_spec;
    }

    return $self->{'filter_spec'};
}

# keep perl happy
1;

__END__

=pod

=head1 SEE ALSO

  Lire::ReportSpec(3pm), Lire::ReportConfig(3pm),
  Lire::ReportSection(3pm)

=head1 AUTHOR

  Francis J. Lacoste <flacoste@logreport.org>

=head1 VERSION

$Id: FilterSpec.pm,v 1.15 2004/06/28 19:46:25 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001, 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
