/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MCardReceive.h"
#include "JT6MDefs.h"

#include "jt6mgui/JT6MApp.h"

#include "common/SoundFile.h"

#include <wx/datetime.h>
#include <wx/debug.h>
#include <wx/log.h>

CJT6MCardReceive::CJT6MCardReceive(CSoundDev* soundDev) :
CJT6MReceive(),
m_soundDev(soundDev)
{
	wxASSERT(m_soundDev != NULL);
}

CJT6MCardReceive::~CJT6MCardReceive()
{
}

bool CJT6MCardReceive::getEndTime()
{
	wxDateTime now = wxDateTime::UNow();

	if (now.GetSecond() != 29 && now.GetSecond() != 59)
		return false;

	return (now.GetMillisecond() > 700);
}

void CJT6MCardReceive::openSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->openRead();
}

void CJT6MCardReceive::closeSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->close();
}

void CJT6MCardReceive::recordAudio(const wxString& id, double* audioData, int length) const
{
	wxASSERT(audioData != NULL);
	wxASSERT(length > 0);

	if (isRecording()) {
		wxString fileName = id + wxT(".wav");

		CSoundFile* file = new CSoundFile();
		file->openWrite(fileName, JT6M_SAMPLE_RATE, 8);

		::wxLogInfo(wxT("%ld: Recording to file: %s"), GetId(), fileName.c_str());

		file->write(audioData, length, 1.0);

		file->close();

		delete file;
	}
}

void CJT6MCardReceive::receiveMessage(CJT6MMessage* message) const
{
	::wxGetApp().receiveCardMessage(message);
}

void CJT6MCardReceive::showLevels(CJT6MLevels* levels) const
{
	::wxGetApp().showCardLevels(levels);
}

wxString CJT6MCardReceive::createId()
{
	wxDateTime now = wxDateTime::Now();

	return now.Format(wxT("%Y%m%d_%H%M%S"), wxDateTime::UTC);
}

void CJT6MCardReceive::error(const wxString& text)
{
	::wxLogError(wxT("%ld: %s"), GetId(), text.c_str());

	::wxGetApp().error(text);
}
