/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <ctype.h>
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "curse.h"
#include "linuxtrade.h"
#include "minihtml.h"
#include "alertipo.h"

/*
 * &position=0050&pagenumber=000
 */
static WINDOW	*Win;
static WINDOW	*Subwin;
static PANEL	*Panel;

static int	Cursor;		// Article line number at top of display
static int	MaxCursor;	// Maximum value for above
static int	NumLines;	// Number of lines in the article

static char	Url[256];
static int	WeekNum = 1;

#define	PADLINES	700

//
// TODO: make this asynchronous
//

static void
display_more(void)
{
	mvwaddch(Win, 1, getmaxx(Win)-1,
		Cursor ? ACS_UARROW : ACS_VLINE);

	mvwaddch(Win, getmaxy(Win)-2, getmaxx(Win)-1,
		(Cursor < MaxCursor) ? ACS_DARROW : ACS_VLINE);
}

static TBLCOL	Col[] =
{
	{  0, 99999},
	{  0, 7 },	//Pricing Date 1
	{  9, 8 },	//Internet related
	{  9, 26 },	//Name
	{ 28, 32 },	//Ticker
	{ 34, 40 },	//Lead Underwriter
	{ 42, 47 },	//Price Range
	{ 49, 53 },	//Issue Size
	{ 55, 61 },	//Offering Amt
	{ 63, 68 },	//Post Offering Shares
	{ 70, 76 },	//Est. Market Value 2
	{ 0, 99999 }
};
#define NUMCOL	asizeof(Col)

static int	FirstWord, FirstRow;

static int
prewordhook(int *tblcolp, char *wbuf, int wlen)
{
	int	tblcol = *tblcolp;

	if (FirstWord)
	{
		minihtml_newline(Subwin);
		FirstWord = 0;
	}

	switch (tblcol)
	{
	case 1:
		if (FirstRow)
		{
			minihtml_newline(Subwin);
			FirstRow = 0;
		}
		if (strcmp(wbuf, "Pricing") == 0) return 0;
		if (strcmp(wbuf, "1") == 0) return 0;
		break;
	case 4:
		if (strcmp(wbuf, "Ticker") == 0)
			{ strcpy(wbuf, "Symbl"); return strlen(wbuf); }
		break;
	case 5:
		if (strcmp(wbuf, "Lead") == 0)
			{ strcpy(wbuf, "Underwriter"); return strlen(wbuf); }
		if (strcmp(wbuf, "Underwriter") == 0) return 0;
		break;
	case 6:
		if (strcmp(wbuf, "Price") == 0)
			{ strcpy(wbuf, "Range"); return strlen(wbuf); }
		if (strcmp(wbuf, "Range") == 0) return 0;
		break;
	case 7:
		if (strcmp(wbuf, "Issue") == 0)
			{ strcpy(wbuf, "Shrs"); return strlen(wbuf); }
		if (strcmp(wbuf, "Size") == 0) return 0;
		break;
	case 8:
		if (strcmp(wbuf, "Offering") == 0)
			{ strcpy(wbuf, "Raising"); return strlen(wbuf); }
		if (strcmp(wbuf, "Amt") == 0) return 0;
		break;
	case 9:
		if (strcmp(wbuf, "Post") == 0)
			{ strcpy(wbuf, "Float"); return strlen(wbuf); }
		if (strcmp(wbuf, "Offering") == 0) return 0;
		if (strcmp(wbuf, "Shares") == 0) return 0;
		break;
	case 10:
		if (strcmp(wbuf, "Est.") == 0)
			{ strcpy(wbuf, "MktVal"); return strlen(wbuf); }
		if (strcmp(wbuf, "Market") == 0) return 0;
		if (strcmp(wbuf, "Value") == 0) return 0;
		if (strcmp(wbuf, "2") == 0) return 0;
		break;
	}
	if (tblcol == 6 && strcmp(wbuf, "Issue") == 0)
		return 0;
	if (tblcol == 6 && strcmp(wbuf, "Offering") == 0) {
		strcpy(wbuf, "$");
		return strlen(wbuf);
	}

	return wlen;
}

static void
anchorhook(char *parmp, int tblcol, int slash)
{
	if (getcurx(Subwin) != 0 && tblcol == 0)
		waddch(Subwin, ' ');
}

static int
tablehook(int tblcnt, TBLCOL **colsp, int *numcolp, int slash)
{
	if (slash && tblcnt)
	{
		if (*colsp)
			*colsp = NULL;
		if (*numcolp)
			*numcolp = 0;
		return 0;
	}
	return tblcnt;
}

static void
get_alertipo(void)
{
	FILE	*fp;
	char	buf[BUFSIZ];
	char	url[BUFSIZ];

	// Paint empty frame to give user some feedback
	mvwcenter(Win, 4, "*** Please wait, fetching data ***");
	clearok(Win, TRUE);
	update_panels(); doupdate();
	mvwcenter(Subwin, 3, "*** No Data Available ***");

	sprintf(url, Url, WeekNum);
	sprintf(buf, "%s \"%s\"", SUCKURL, url);

	if (Debug)
		fprintf(stderr, "CMD: %s\n", buf);

	fp = popen(buf, "r");
	if (!fp)
	{
		mvwcenter(Win, 4, "   *** Can't access alertipo ***   ");
		touchwin(Win);
		return;
	}

	/*
	 * Eat lines until we see the table
	 */
	minihtml_skip_past_line(fp, "<p align=center>Week Ending");

	/*
	 * Parse HTML
	 */
	FirstWord = 1;
	FirstRow = 1;
	minihtml_parse(Subwin, fp, Col, NUMCOL, MHP_DEFAULT,
			prewordhook, NULL, anchorhook, tablehook);

	pclose(fp);

	Cursor = 0;
	NumLines = getcury(Subwin) + 1;
	MaxCursor = NumLines - (getmaxy(Win) - 2);
	if (MaxCursor < 0)
		MaxCursor = 0;

	display_more();

	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();
}

static
void
display_popup_title(void)
{
	char		*fmt = "Alert!IPO Calendar";

	mvwcenter(Win, 0, fmt);
}

void
alertipo_popup(STREAMER sr)
{
	int	n;
	int	cols;

	// Clear alert, if any
	mvprintw(1, 7, "      ");

	n = LINES - 4 - 2 - NumStock - 12;
	if (n < 24)
		n = 24;
	Win = bestwin(n);
	if (!Win)
		error(1, "Can't create alertipo window\n");

	cols = getmaxx(Win);

	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	box(Win, 0, 0);
	// mvwprintw(Win, 0, (cols-17)/2, "Earnings Calendar");

	Subwin = newpad(PADLINES, cols - 2);
	if (!Subwin)
		error(1, "Can't create alertipo pad\n");
	wbkgd(Subwin, Reverse ? A_REVERSE : A_NORMAL);

	Panel = new_panel(Win);

	strcpy(Url, "http://www.alert-ipo.com/cgi-bin/ai.exe"
			"?cobrand=ostman&dynamic=upcoming&set=%d");
	WeekNum = 1;
	display_popup_title();

	get_alertipo();
}

static void
popdown(void)
{
	hide_panel(Panel);
	update_panels();
	del_panel(Panel);
	delwin(Subwin);
	delwin(Win);
	Win = 0;
	Subwin = 0;
}

int
alertipo_command(int c, STREAMER sr)
{
	MEVENT		m;

	switch (c)
	{
	case '\f':
		move(LINES-1, CursorX);
		wrefresh(curscr);
		return -1;
	case 'j':
	case KEY_DOWN:
		if (++Cursor > MaxCursor)
		{
			--Cursor;
			beep();
			break;
		}
		break;
	case 'k':
	case KEY_UP:
		if (--Cursor < 0)
		{
			++Cursor;
			beep();
			break;
		}
		break;
	case CTRL('u'):
	case CTRL('b'):
	case KEY_PPAGE:
		if (Cursor == 0)
		{
			if (WeekNum)
			{
				--WeekNum;
				goto getnew;
			}
			else
			{
				beep();
				break;
			}
		}
		Cursor -= getmaxy(Win) - 2 - 1;
		if (Cursor < 0)
			Cursor = 0;
		break;
	case ' ':
	case CTRL('d'):
	case CTRL('f'):
	case KEY_NPAGE:
		if (Cursor == MaxCursor)
		{
			++WeekNum;
			goto getnew;
		}
		Cursor += getmaxy(Win) - 2 - 1;
		if (Cursor > MaxCursor)
			Cursor = MaxCursor;
		break;
	case '0':
	case KEY_HOME:
		Cursor = 0;
		break;
	case '$':
	case KEY_END:
		Cursor = MaxCursor;
		break;

	case 'l':
	case KEY_RIGHT:
	case '+':
		++WeekNum;
		goto getnew;
	case 'h':
	case KEY_LEFT:
	case '-':
		--WeekNum; if (WeekNum < 1) ++WeekNum;
	getnew:
		Cursor = 0;
		werase(Subwin);
		copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
		display_popup_title();
		move(LINES-1, CursorX);
		update_panels();
		doupdate();
		get_alertipo();
		break;

	case KEY_F(11):
		print_rect_troff(getbegy(Win), getbegx(Win),
				getmaxy(Win), getmaxx(Win),
				NULL, "screen.tr");
		break;
	case KEY_F(12):
	case CTRL('P'):
	case KEY_PRINT:
		print_window(Subwin, NumLines,
				get_rc_value(RcFile, "print_cmd"));
		break;

		// Change stocklist on main screen
	case '1': case '2': case '3': case '4': case '5':
	case '6': case '7': case '8': case '9':
		return 3;

	case KEY_MOUSE:
		if (getmouse(&m) != OK)
			break;

		// Clicks in our window ...
		if (m.y >= getbegy(Win)
			&& m.y < getbegy(Win) + getmaxy(Win))
		{
			// int y = m.y - getbegy(Win) - 1 + Cursor;
		}

		// popdown and reprocess clicks in main window
		if (ungetmouse(&m) == OK)
			Ungetch = 1;
		popdown();
		return 2;

		// Quick switches to another popup
	case 'p':
	case 'u':
		popdown();
		return 1;

		// Regular exit
	case 033:
	case 'q':
	case 'x':
		popdown();
		return 2;
	default:
		beep();
		break;
	}

	display_more();
	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();

	return (-1);
}
