/*
        linuxinfo_sparc.c

        Copyright (C) 1998-2000
        All Rights Reserved.

        Alex Buell <alex.buell@tahallah.demon.co.uk>

        Advanced Buell Software Engineering Ltd
        Hampshire, GU31 5DG
        United Kingdom

        Version Author  Date            Comments
        ----------------------------------------------------------------------
        1.0.0   AIB     199803??        Initial development
	1.0.1	AIB	20000405	Rewritten

        This is the Sparc port of linuxinfo
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include "linuxinfo.h"

#ifdef system_sparc

void GetHardwareInfo(int fd, struct hw_stat *hw)
{
        float bogomips = 0.0;
        LONGLONG memory = 0;
        int processors = 0;
        float tempbogo;

        char temp_string[BUFSIZ], temp_string2[BUFSIZ];
        char chip[BUFSIZ], vendor[BUFSIZ], model[BUFSIZ];

        struct stat st_buf;

	while (read_line(fd, temp_string, BUFSIZ) != 0)
	{
		splitstring(temp_string, temp_string2);

		if (!(strncmp(temp_string, "ncpus", strlen("ncpus"))) && (processors == 0))
			sscanf(temp_string2, "%d", &processors);

		if (!(strncmp(temp_string, "cpu ", strlen("cpu "))))
		{
			strcpy(model, temp_string2);

			if (strstr(temp_string2, "Texas") != NULL)
				strcpy(vendor, "TI");

			if (strstr(temp_string2, "Cypress") != NULL)
				strcpy(vendor, "Cypress");

			if (strstr(temp_string2, "SuperSparc") != NULL)
				strcpy(vendor, "SuperSparc");	
		}

		if (!(strncmp(temp_string, "BogoMips", strlen("BogoMips"))))
			sscanf(temp_string2, "%f", &tempbogo);
	}

        stat(MEMORY_FILE, &st_buf);
        memory = st_buf.st_size;
        memory /= 1024; memory /= 1024;
        sprintf(hw->hw_memory, "%ld", (long int)memory);

        hw->hw_processors = processors;

	strcat(hw->hw_megahertz, "?");
        sprintf(hw->hw_cpuinfo, "%s %s", vendor, model);
        sprintf(hw->hw_bogomips, "%.2f", tempbogo * processors);
}

#endif /* system_sparc */
