#include <string.h>
#include <stdlib.h>
#include "xconf.h"
#include "section.h"

PUBLIC PAIRES::PAIRES(
	const char *keyword,
	const char *value)
{
	keyw = strdup(keyword);
	arg  = strdup(value);
}
PUBLIC VIRTUAL PAIRES::~PAIRES()
{
	free (keyw);
	free (arg);
}


PUBLIC OPTION::OPTION(
	const char *keyword,
	const char *value)
	: PAIRES (keyword,value)
{
}
/*
	Merge an OPTION into another
*/
PUBLIC VIRTUAL void OPTION::merge (const OPTION *src)
{
	free (arg);
	arg = strdup(src->arg);
}

/*
	Make a copy of itself
*/
PUBLIC VIRTUAL OPTION *OPTION::clone() const
{
	return new OPTION (keyw,arg);
}
/*
	Formatte and output an option and suboption in ascii
*/
PUBLIC VIRTUAL void OPTION::print (FILE *fout) const
{
	fprintf (fout,"%s %s\n",keyw,arg);
}

/*
	Validate the option value and suboption
	Return -1 if something is wrong. msg will contain an explanation.

	The default is to allow anything.
*/
PUBLIC VIRTUAL int OPTION::validate (char *msg)
{
	msg[0] = '\0';
	return 0;
}
/*
	Get one OPTION of the table or NULL
*/
PUBLIC OPTION *OPTIONS::getitem(int no) const
{
	return (OPTION*)ARRAY::getitem(no);
}

/*
	Formatte and output an option and suboption in ascii
*/
PUBLIC VIRTUAL void OPTIONS::print (FILE *fout,int indent) const
{
	for (int i=0; i<getnb(); i++){
		for (int j=0; j<indent; j++) fputc ('\t',fout);
		getitem(i)->print (fout);
	}
}

PUBLIC SECTION::SECTION(const char *_name)
{
	name = strdup(_name);
}
PUBLIC VIRTUAL SECTION::~SECTION()
{
	free (name);
}

/*
	Formatte and output an option and suboption in ascii
*/
PUBLIC void SECTION::print (FILE *fout,int indent) const
{
	fprintf (fout,"Section \"%s\"\n",name);
	OPTIONS::print(fout,indent);
	fprintf (fout,"EndSection\n");
}

/*
	Validate all suboption of a section.
	Return -1 if any error. Error messages will be appended
	in msg.
*/
PUBLIC int SECTION::validate (char *msg)
{
	int ret = 0;
	for (int i=0; i<getnb(); i++){
		ret |= getitem(i)->validate (msg);
	}
	return ret;
}

