#pragma interface
#ifndef USERCONF_H
#define USERCONF_H

struct passwd;
struct group;

// #Specbeg: user category
#define TUSER_STD		1
#define TUSER_PPP		2
#define TUSER_SLIP		3
#define TUSER_UUCP		4
#define TUSER_SPECIAL	5
#define TUSER_POP		6
#define TUSER_ADMIN		7
// #Specend:

#define USRACCT_EDITPRIV		1
#define USRACCT_EDITGROUP		2
#define USRACCT_EDITSHELL		4
#define USRACCT_EDITSUPGRP		8

#define USRACCT_EDITALL			(USRACCT_EDITPRIV|USRACCT_EDITGROUP|USRACCT_EDITSHELL|USRACCT_EDITSUPGRP)



class USER;
class USERS;
class GROUPS;
class SHADOW;
class DIALOG;
class DIALOG_RECORDS;
class USERACCT_COMNG;
class USERACCT_COMNGS;

#include <misc.h>

class PRIVILEGE_DECLARATOR{
public:
	PRIVILEGE_DECLARATOR *next;
	void (*fct)();
	/*~PROTOBEG~ PRIVILEGE_DECLARATOR */
public:
	PRIVILEGE_DECLARATOR (void (*_fct)());
	/*~PROTOEND~ PRIVILEGE_DECLARATOR */
};

class PRIVILEGE_DATA: public ARRAY_OBJ{
protected:
	int first_field;	// Number of the first field in the dialog
	char active;
public:
	virtual void setdialog(const char *title,DIALOG &dia)=0;
	virtual int validate()=0;
	virtual int format_ascii(char *line)=0;
	/*~PROTOBEG~ PRIVILEGE_DATA */
public:
	int has_priv (void);
	int mustident (void);
	/*~PROTOEND~ PRIVILEGE_DATA */
};

class TRANS_NOTLOAD;

class PRIVILEGE_DATAS: public ARRAY{
	/*~PROTOBEG~ PRIVILEGE_DATAS */
public:
	PRIVILEGE_DATA *getitem (int no);
	/*~PROTOEND~ PRIVILEGE_DATAS */
};

class PRIVILEGE: public ARRAY_OBJ{
	struct {
		TRANS_NOTLOAD *title;
		TRANS_NOTLOAD *section;
	}msg;
	struct {
		SSTRING title;
		SSTRING section;
	}str;
public:
	SSTRING id;		// Name of the priviledge
	PRIVILEGE *next;
	/*~PROTOBEG~ PRIVILEGE */
public:
	PRIVILEGE (const char *_id,
		 TRANS_NOTLOAD *_title,
		 TRANS_NOTLOAD *_section);
	PRIVILEGE (const char *_id,
		 const char *_title,
		 const char *_section);
	virtual PRIVILEGE_DATA *getdata (const char *user);
	const char *getsection (void);
	const char *gettitle (void);
	virtual int savedata (const char *user,
		 PRIVILEGE_DATA *data);
	~PRIVILEGE (void);
	/*~PROTOEND~ PRIVILEGE */
};

class PRIVI_FEATURE: public PRIVILEGE{
	/*~PROTOBEG~ PRIVI_FEATURE */
public:
	PRIVI_FEATURE (const char *_id,
		 TRANS_NOTLOAD *_title,
		 TRANS_NOTLOAD *_section);
	PRIVILEGE_DATA *getdata (const char *user);
	/*~PROTOEND~ PRIVI_FEATURE */
};

class PRIVILEGES: public ARRAY{
	/*~PROTOBEG~ PRIVILEGES */
public:
	PRIVILEGES (void);
	PRIVILEGE *getitem (int no);
	/*~PROTOEND~ PRIVILEGES */
};

class USERPRIVI_COMNG;
// Use to associate a help for the privilege section of the user account
// dialog.
class REGISTER_PRIVI_HELP{
	friend USERPRIVI_COMNG;
	REGISTER_PRIVI_HELP *next;
	TRANS_NOTLOAD *title;
	HELP_FILE &help;
	/*~PROTOBEG~ REGISTER_PRIVI_HELP */
public:
	REGISTER_PRIVI_HELP (HELP_FILE&_help,
		 TRANS_NOTLOAD *_title);
	/*~PROTOEND~ REGISTER_PRIVI_HELP */
};

class QUOTA_EDIT;

enum USER_DELOPER {
	DELOPER_NONE,		// Do nothing
	DELOPER_ARCHIVE,	// Archive the home and inbox
	DELOPER_DELETE,		// Delete them
	DELOPER_KEEP,		// Keep the files
};

class USER: public ARRAY_OBJ{
	friend class USERS;
	char enabled;		// This account is enabled
	char was_enabled;	// So we see if the status have changed during
						// edit
	SSTRING name;
	SSTRING passwd;
	int uid;
	int gid;
	SSTRING comment;
	SSTRING wrkdir;
	SSTRING shell;
	SSTRING altgr;
	bool special;		// Special user accounts like uucp and slip
						// Whatever is using a shell for non human.
	SSTRING oldname;	// To rename an account
	/*~PROTOBEG~ USER */
public:
	USER (const USER *usr);
	USER (const char *_name,
		 const char *_passwd,
		 int _uid,
		 int _gid,
		 const char *_gecos,
		 const char *_dir,
		 const char *_shell);
	USER (const char *line);
	USER (struct passwd *p);
	USER (void);
private:
	int check (USERS&users, GROUPS&groups);
public:
	int checkhome (SSTRING *status, const char *group);
private:
	bool deldialog (USER_DELOPER&deloper);
public:
	int edit (USERS&users,
		 GROUPS&groups,
		 bool is_new,
		 PRIVILEGE *priv,
		 unsigned may_edit,
		 QUOTA_EDIT&qedit,
		 USERACCT_COMNGS&comngs,
		 USER_DELOPER&deloper,
		 const char *domain);
	int edithispass (SHADOW *shadow,
		 bool may_override,
		 const char *domain);
	int edithispass_notty (SHADOW *shadow,
		 const char *domain);
	int editpass (SHADOW *shadow,
		 bool confirm,
		 bool may_override,
		 const char *domain);
	const char *getaltgrs (void)const;
	int getcateg (void)const;
	const char *getgecos (void)const;
	void getgecos_esc (char *buf, int size);
	int getgid (void)const;
	const char *gethome (void)const;
	const char *getname (void)const;
	const char *getoldname (void)const;
	const char *getpwd (void)const;
	const char *getshell (void)const;
	int getuid (void)const;
private:
	void init (const char *_name,
		 const char *_passwd,
		 int _uid,
		 int _gid,
		 const char *_gecos,
		 const char *_dir,
		 const char *_shell);
public:
	bool is_admin (void)const;
	bool is_like (const USER *other)const;
	bool is_locked (SHADOW *shadow);
	bool is_logged (void);
	bool is_special (void)const;
	int pass_maychange (SHADOW *shadow);
	int passwd_locked (SHADOW *shadow);
	void setdefhome (USERS&users, const char *group);
	void setgecos (const char *_gecos);
	int sethome (PRIVILEGE *priv,
		 const char *group,
		 bool do_recur,
		 USERS&users);
	void setlike (const USER *other);
	void setname (const char *_name);
	bool statuschanged (bool&active);
	void update_passwd (const char *newp,
		 SHADOW *shadow,
		 bool is_lock,
		 const char *domain);
	void write (FILE_CFG *fout);
	~USER (void);
	/*~PROTOEND~ USER */
};

class USERS: public ARRAY{
	USER *nisentry;
	bool nis_at_end;		// NIS entry at the end or beginning
	class SHADOWS *shadows;
	CONFIG_FILE *configf;
	SSTRING home;		// base directory for users home directory
	int baseuid;		// Starting point for UID allocation
	SSTRING domain;		// Domain associated with these accounts
						// / or a virtual email domain
	SSTRING root;		// root directory of the domain / or vhome/domain
						// gnrally
	int maxusers; 		// Max number of users in this domain (0 is unlimited)
	/*~PROTOBEG~ USERS */
public:
	USERS (CONFIG_FILE&_file,
		 CONFIG_FILE&_shadow,
		 const char *_root,
		 const char *_home,
		 const char *_domain,
		 int _baseuid);
private:
	USERS (USERS *users);
public:
	USERS (void);
	int addbatch (const char *id,
		 const char *group,
		 const char *name,
		 const char *shell,
		 bool locked);
	int addone (USER *special,
		 const char *name,
		 const char *fullname,
		 PRIVILEGE *priv,
		 unsigned may_edit);
	void addshadow (SHADOW *shadow);
	int delbatch (const char *id, USER_DELOPER oper);
private:
	int docreate (USER *usr,
		 PRIVILEGE *priv,
		 const char *group);
public:
	int dodel (USER *usr,
		 USER_DELOPER oper,
		 GROUPS&groups,
		 PRIVILEGE *priv);
	int edit (USER *special,
		 PRIVILEGE *priv,
		 unsigned may_edit);
	int editone (USER *usr,
		 bool is_new,
		 PRIVILEGE *priv,
		 unsigned may_edit);
private:
	int editone_precut (USER *usr,
		 bool is_new,
		 PRIVILEGE *priv,
		 unsigned may_edit);
public:
	const char *getdomain (void)const;
	USER *getfromuid (int uid);
	USER *getfromuid (int uid, USER *exclude);
	USER *getitem (const char *name);
	USER *getitem (const char *name, USER *exclude);
	USER *getitem (int no);
	int getnewuid (void);
	const char *getroot (void)const;
	SHADOW *getshadow (USER *usr);
	const char *getstdhome (const char *group)const;
	const char *getstdhome (void)const;
	bool has_add_override (void);
	int has_shadow (void)const;
	bool may_override (void);
private:
	int override (PRIVILEGE *priv,
		 USER *usr,
		 int (*fct)(USER *, SHADOW *));
	int override_add (PRIVILEGE *priv,
		 USER *usr,
		 const char *group);
	void readusers (void);
	void reload (void);
public:
	void remove_del (USER *usr);
private:
	int runcmd (const char *cmd,
		 USER *usr,
		 const char *group);
protected:
	int runcreatecmd (USER *usr, const char *group);
	int rundeletecmd (USER *usr, const char *group);
public:
	USER *select (USER *like,
		 int may_add,
		 MENU_STATUS&code,
		 DIALOG_RECORDS&dia,
		 int &choice,
		 struct USRACC_FILTER&filter);
private:
	USER *select_sorted (USER *like,
		 int may_add,
		 MENU_STATUS&code,
		 DIALOG_RECORDS&dia,
		 int &choice,
		 struct USRACC_FILTER&filter);
public:
	void setmaxusers (int mx);
private:
	MENU_STATUS setselectprefix (struct USRACC_FILTER&filter,
		 const USER *like,
		 bool may_add);
public:
	void sortbygid (void);
	void sortbyname (void);
	int write (PRIVILEGE *priv);
	int writeif (PRIVILEGE *priv);
	int writeif (PRIVILEGE *priv, USER *&usr);
	~USERS (void);
	/*~PROTOEND~ USERS */
};

class SHADOW: public ARRAY_OBJ{
	friend class SHADOWS;
	friend class USER;
	friend class USERS;
	SSTRING name;
	SSTRING passwd;
	int last;
	int may;
	int must;
	int warn;
	int expire;
	int disable;
	SSTRING reserved;
	/*~PROTOBEG~ SHADOW */
public:
	SHADOW (const char *line);
	SHADOW (void);
	int getdisable (void)const;
	int getexpire (void)const;
	int getmaychange (void)const;
	int getmustchange (void)const;
	const char *getpwd (void)const;
	int getwarn (void)const;
private:
	void initdef (void);
public:
	void setdialog (DIALOG&dia);
	void setname (const char *_name);
	void setpasswd (const char *_pass);
	void write (FILE_CFG *fout);
	int writedef (void);
	/*~PROTOEND~ SHADOW */
};


class GROUP: public ARRAY_OBJ{
	friend GROUPS;
	SSTRING name;
	SSTRING passwd;
	int gid;
	SSTRINGS tbmem;	// User member of this group (not their primary group)
	/*~PROTOBEG~ GROUP */
public:
	GROUP (const char *_name,
		 const char *_passwd,
		 int _gid,
		 char **members);
	GROUP (const char *_name,
		 const char *_passwd,
		 int _gid,
		 const SSTRINGS&members);
	GROUP (const char *line);
	GROUP (void);
	void addmember (const char *user);
private:
	int check (USERS&users,
		 GROUPS&groups,
		 GROUP *realone);
public:
	int delmember (const char *user);
	int edit (USERS&users, GROUPS&groups);
	int getgid (void);
	const char *getname (void);
private:
	void init (const char *_name,
		 const char *_passwd,
		 int _gid);
public:
	bool is_member (const char *user);
private:
	void settbmem (char **members);
	void settbmem (const SSTRINGS&members);
public:
	void write (FILE_CFG *fout);
	~GROUP (void);
	/*~PROTOEND~ GROUP */
};

class FIELD_COMBO;

class GROUPS: public ARRAY{
	GROUP *nisentry;
	bool nis_at_end;		// NIS entry at the end or beginning
	/*~PROTOBEG~ GROUPS */
private:
	GROUPS (GROUPS *groups);
public:
	GROUPS (void);
	int create (const char *name, int hint);
	int delmember (const char *user);
	int edit (void);
	void getalt (const char *user, SSTRING&alt);
	const char *getdefault (void)const;
	GROUP *getfromgid (int gid)const;
	int getgid (const char *name)const;
	GROUP *getitem (const char *name)const;
	GROUP *getitem (int no)const;
	int getnew (int hint);
	int getnew (void);
	void load_special (void);
	void remove_del (GROUP *grp);
	int setalt (const char *user,
		 const char *groups,
		 char delim,
		 bool test);
	void setcombo (FIELD_COMBO *grpl);
	void sortbyid (void);
	void sortbyname (void);
	int write (PRIVILEGE *priv);
	int write (PRIVILEGE *priv, CONFIG_FILE&file);
	int write (void);
	~GROUPS (void);
	/*~PROTOEND~ GROUPS */
};

class DICTIONARY;

#include "userconf.p"

#endif

