#ifndef procterm_h
#define procterm_h
#pragma interface

#include <sys/types.h>
#include <misc.h>

class PROCTERM: public ARRAY_OBJ{
	uid_t uid;
	pid_t ppid;
	SSTRING command;		// path of the program executed
public:
	pid_t pid;				// Process ID of the program
	int inode;				// Socket inode
	unsigned long ip;		// Remote IP, host order
	unsigned port;			// Remote port, host order
	/*~PROTOBEG~ PROCTERM */
public:
	PROCTERM (int _pid,
		 int _inode,
		 unsigned long _ip,
		 unsigned _port);
	const char *getexepath (void);
	pid_t getppid (void);
	uid_t getuid (void);
private:
	void loadprcinfo (void);
public:
	/*~PROTOEND~ PROCTERM */
};

class PROCTERMS: public ARRAY{
	/*~PROTOBEG~ PROCTERMS */
public:
	int extractip (const char *ip,
		 PROCTERMS&extr)const;
	PROCTERM *getitem (int no)const;
	/*~PROTOEND~ PROCTERMS */
};

#include "xterminals.p"

#endif
