
#include <stdio.h>
#include <string.h>
#include "wineconf.h"
#include "wineconf.m"
#include <fviews.h>
#include "wineconf_global_defs.h"
#include "wineconf_tools.h"

#define  SELECTED_PARALLEL_DEVICE 1
#define  SELECTED_SERIAL_DEVICE   2

void edit_parallel_assign(const char *given_name, VIEWITEMS &given_vitems, CONFIG_FILE &cf_wineconf)
{
    DIALOG      dia_parallel;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    char        my_title[TYPICAL_STRING_SIZE];
    char        second_varname[TYPICAL_STRING_SIZE];
    /* gui */
    FIELD_COMBO *co_paralleldevice;
    FIELD_COMBO *co_parallelspool;
    SSTRING     parallel_device;
    char        use_low_level;
    SSTRING     parallel_spool;
    char        use_spooler;

    /* creates the varname needed for [spooler] group */
    strcpy(second_varname, given_name);
    convert_string_to_highercase(second_varname);
    strcat(second_varname, ":");

    if(load_var_data("parallelports", given_name, given_vitems, parallel_device)){
        use_low_level=1;
    }else{
        use_low_level=0;
    }

    if(load_var_data("spooler", second_varname, given_vitems, parallel_spool)){
        use_spooler=1;
    }else{
        use_spooler=0;
    }

    dia_parallel.newf_chk("", use_low_level, MSG_U(F_ASSIGNPARALLELDEV, "Assign parallel device (low level)"));
    co_paralleldevice=dia_parallel.newf_combo(MSG_U(F_PARALLELDEVICE, "Parallel device:"), parallel_device);
    co_paralleldevice->addopt("/dev/lp0");
    co_paralleldevice->addopt("/dev/lp1");
    co_paralleldevice->addopt("/dev/lp2");
    dia_parallel.newf_chk("", use_spooler, MSG_U(F_ASSIGNSPOOLER, "Assign spooler (high level)"));
    co_parallelspool=dia_parallel.newf_combo(MSG_U(F_SPOOLER, "Spooler:"), parallel_spool);
    co_parallelspool->addopt("|lpr");
    co_parallelspool->addopt("/dev/lp0");
    co_parallelspool->addopt("/dev/lp1");
    co_parallelspool->addopt("/dev/lp2");

    sprintf(my_title, MSG_U(T_EDITINGDEVICE, "Editing device %s"), given_name);
    my_button=dia_parallel.editmenu(my_title, MSG_U(I_DEFINEPARASSIGNCHARACTS, "Define the assign characteristics\nfor this parallel port."), help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_DEL:
        write_var_data("parallelports", given_name, "", given_vitems, 1);
        write_var_data("spooler", second_varname, "", given_vitems, 1);
        given_vitems.write(cf_wineconf, NULL);
        break;
    case MENU_ACCEPT:
        if(use_low_level){
            write_var_data("parallelports", given_name, parallel_device.get(), given_vitems, 0);
        } else {
            write_var_data("parallelports", given_name, "", given_vitems, 1);
        }
        if(use_spooler){
            write_var_data("spooler", second_varname, parallel_spool.get(), given_vitems, 0);
        } else {
            write_var_data("spooler", second_varname, "", given_vitems, 1);
        }
        given_vitems.write(cf_wineconf, NULL);
        break;
    default:
        break;
    }
}

void edit_serial_assign(const char *given_name, VIEWITEMS &given_vitems, CONFIG_FILE &cf_wineconf)
{
    DIALOG      dia_serial;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    FIELD_COMBO *co_serialdevice;
    SSTRING     serial_device;
    char        my_title[TYPICAL_STRING_SIZE];

    load_var_data("serialports", given_name, given_vitems, serial_device);

    co_serialdevice=dia_serial.newf_combo(MSG_U(F_SERIALDEVICE, "Serial device:"), serial_device);
    co_serialdevice->addopt("/dev/ttyS0");
    co_serialdevice->addopt("/dev/ttyS1");
    co_serialdevice->addopt("/dev/ttyS2");
    co_serialdevice->addopt("/dev/ttyS3");
    co_serialdevice->addopt("/dev/modem");

    sprintf(my_title, MSG_R(T_EDITINGDEVICE), given_name);
    my_button=dia_serial.editmenu(my_title, MSG_U(I_DEFINESERASSIGNCHARS, "Select the device you want\nto assign to this serial port."), help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_DEL:
        write_var_data("serialports", given_name, "", given_vitems, 1);
        given_vitems.write(cf_wineconf, NULL);
        break;
    case MENU_ACCEPT:
        write_var_data("serialports", given_name, serial_device.get(), given_vitems, 0);
        given_vitems.write(cf_wineconf, NULL);
        break;
    default:
        break;
    }
}

/* fill list with the defined parallel ports */
void fill_with_all_parallel_ports(DIALOG_RECORDS &dia_devices, VIEWITEMS &given_vitems, SSTRINGS &my_sstrings, int &current_table_position)
{
    int my_counter=0;
    char my_buff[TYPICAL_STRING_SIZE];
    char my_buff2[TYPICAL_STRING_SIZE];

    while(++my_counter<9){
        sprintf(my_buff, "Lpt%d", my_counter);
        sprintf(my_buff2, "LPT%d:", my_counter);
        if(return_var_data_location("parallelports", my_buff, given_vitems)||
           return_var_data_location("spooler", my_buff2, given_vitems)){
            /* add to sstrings */
            SSTRING *my_sstring=new SSTRING;
            my_sstring->setfrom(my_buff);
            my_sstrings.add(my_sstring);
            /* add to list */
            dia_devices.set_menuitem(current_table_position++, my_buff, MSG_U(X_PARALLELPORT, "parallel port"));
        }
    }
}

/* fill list with the defined serial ports */
void fill_with_all_serial_ports(DIALOG_RECORDS &dia_devices, VIEWITEMS &given_vitems, SSTRINGS &my_sstrings, int &current_table_position)
{
    int my_counter=0;
    char my_buff[TYPICAL_STRING_SIZE];

    while(++my_counter<9){
        sprintf(my_buff, "Com%d", my_counter);
        if(return_var_data_location("serialports", my_buff, given_vitems)){
            /* add to sstrings */
            SSTRING *my_sstring=new SSTRING;
            my_sstring->setfrom(my_buff);
            my_sstrings.add(my_sstring);
            /* add to list */
            dia_devices.set_menuitem(current_table_position++, my_buff, MSG_U(X_SERIALPORT, "serial port"));
        }
    }
}

/* fill FIELD_LIST with available devices */
/* aux routine for add_a_device(...) */
void fill_with_avail_devs(SSTRINGS &my_sstrings, FIELD_LIST *given_field_list, char *given_prefix)
{
    int my_step;
    const char *which_item_selected;
    int total_of_entries;
    char my_string[TYPICAL_STRING_SIZE];
    int my_big_loop=0;
    int may_use_that; /* if true, that port is vacant so it'll be listed */

    while(++my_big_loop<9){
        sprintf(my_string, "%s%d", given_prefix, my_big_loop);
        total_of_entries=my_sstrings.getnb();
        may_use_that=1;
        my_step=0;
        while(total_of_entries--){
            which_item_selected=my_sstrings.getitem(my_step++)->get();
            if(!(strcmp(which_item_selected, my_string)))
                may_use_that=0;
        }
        if(may_use_that)
            given_field_list->addopt(my_string);
    }
}

/* pop an 'add a device' window.
   list of already-defined devices shall be provided */
void add_a_device(SSTRINGS &my_sstrings, VIEWITEMS &vitems_wineconf, CONFIG_FILE &cf_wineconf)
{
    DIALOG dia_whichdevice;
    char   device_type=1;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    FIELD_LIST *parallel_list;
    FIELD_LIST *serial_list;
    SSTRING    chosen_parallel;
    SSTRING    chosen_serial;

    /* parallel */
    dia_whichdevice.newf_radio("", device_type, SELECTED_PARALLEL_DEVICE, "parallel:");
    chosen_parallel.setfrom(MSG_U(F_NOTDEFINED, "(not defined)"));
    parallel_list=dia_whichdevice.newf_list("", chosen_parallel);
    parallel_list->addopt("", MSG_R(F_NOTDEFINED), "");
    fill_with_avail_devs(my_sstrings, parallel_list, "Lpt");

    /* serial */
    dia_whichdevice.newf_radio("", device_type, SELECTED_SERIAL_DEVICE, "serial:");
    chosen_serial.setfrom(MSG_R(F_NOTDEFINED));
    serial_list=dia_whichdevice.newf_list("", chosen_serial);
    serial_list->addopt("", MSG_R(F_NOTDEFINED), "");
    fill_with_avail_devs(my_sstrings, serial_list, "Com");

    my_button=dia_whichdevice.editmenu(MSG_U(T_ADDINGANEWDEVICE, "Adding a new device"), "", help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ACCEPT:
        switch(device_type){
        case SELECTED_PARALLEL_DEVICE:
            if(*chosen_parallel.get()){
                char another_temp_string[TYPICAL_STRING_SIZE];
                sprintf(another_temp_string, "%s:", chosen_parallel.get());
                convert_string_to_highercase(another_temp_string);
                write_var_data("spooler", another_temp_string, "|lpr", vitems_wineconf, 1);
                edit_parallel_assign(chosen_parallel.get(), vitems_wineconf, cf_wineconf);
            }
            break;
        case SELECTED_SERIAL_DEVICE:
            if(*chosen_serial.get()){
                write_var_data("serialports", chosen_serial.get(), MSG_U(X_DEVSOMEDEVICE, "/dev/some_serial_device"), vitems_wineconf, 1);
                edit_serial_assign(chosen_serial.get(), vitems_wineconf, cf_wineconf);
            }
            break;
        default:
            break;
        }
        break;
    default:
        break;
    }
}

/* main window (lists devices available) */
void manage_devices_settings(VIEWITEMS &vitems_wineconf, CONFIG_FILE &cf_wineconf)
{
    DIALOG_RECORDS dia_devices;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    dia_devices.newf_head("", MSG_U(T_NAMETYPE, "name\ttype"));

    while(1){
        SSTRINGS    my_sstrings;
        int         current_table_position=0;

        fill_with_all_serial_ports(dia_devices, vitems_wineconf, my_sstrings, current_table_position);
        fill_with_all_parallel_ports(dia_devices, vitems_wineconf, my_sstrings, current_table_position);

        // remove entries below (they're the previous ones and useless now)
        dia_devices.remove_last(current_table_position+1);

        my_button=dia_devices.editmenu(MSG_U(T_ASSIGNEDDEVICES, "Assigned devices"), "", devices_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            add_a_device(my_sstrings, vitems_wineconf, cf_wineconf);
            break;
        default:
            {
                const char *which_item_selected;
                which_item_selected=my_sstrings.getitem(my_selection)->get();
                if(*which_item_selected=='L'){
                    edit_parallel_assign(which_item_selected, vitems_wineconf, cf_wineconf);
                } else {
                    edit_serial_assign(which_item_selected, vitems_wineconf, cf_wineconf);
                }
            }
        }
    }
}

