#include <stdio.h>
#include <string.h>
#include <misc.h>
#include "internal.h"
#include "uucp.h"
#include "uucp.m"
#include "../paths.h"

extern UUCP_HELP_FILE help_uucp;
static CONFIG_FILE f_perms (VAR_LIB_UUCP_PERMS
	,help_uucp
	,CONFIGF_OPTIONNAL|CONFIGF_MANAGED
	,"uucp","uucp",0660,subsys_uucp);

static const char MACHINE[] = "MACHINE";
static const char COMMANDS[] = "COMMANDS";
static const char LOGNAME[] = "LOGNAME";
static const char MYNAME[] = "MYNAME";
static const char READ[] = "READ";
static const char WRITE[] = "WRITE";
static const char SENDFILES[] = "SENDFILES";
static const char REQUEST[] = "REQUEST";



PUBLIC PERMISSION::PERMISSION ()
{
	commands.setfrom ("rmail:rnews");
	dirread.setfrom ("/var/spool/uucppublic");
	dirwrite.setfrom ("/var/spool/uucppublic");
	maysend = mayrequest = 1;
}

PUBLIC PERMISSION::PERMISSION (const PERMISSION *p)
{
	commands.setfrom (p->commands);
	dirread.setfrom (p->dirread);
	dirwrite.setfrom (p->dirwrite);
	maysend = p->maysend;
	mayrequest = p->mayrequest;
	logname.setfrom(p->logname);
	myname.setfrom (p->myname);
	comments.setfrom (p->comments);
	machine.setfrom (p->machine);
}

PUBLIC PERMISSION::PERMISSION (
	const char *buf,	// Buffer to parse from the Permissions file
	const SSTRING &_comments,	// Comments preceding the definition
	char *err)			// Will contain error message or '\0'
{
	comments.setfrom (_comments);
	comments.strip_end();
	err[0] = '\0';
	while (1){
		char word[1000];
		buf = str_copyword(word,buf,sizeof(word));
		if (word[0] == '\0'){
			break;
		}else{
			char *equal = strchr(word,'=');
			if (equal != NULL){
				*equal++ = '\0';
				if (strcmp(word,MACHINE)==0){
					machine.setfrom (equal);
				}else if (strcmp(word,COMMANDS)==0){
					commands.setfrom (equal);
				}else if (strcmp(word,LOGNAME)==0){
					logname.setfrom (equal);
				}else if (strcmp(word,MYNAME)==0){
					myname.setfrom (equal);
				}else if (strcmp(word,READ)==0){
					dirread.setfrom (equal);
				}else if (strcmp(word,WRITE)==0){
					dirwrite.setfrom (equal);
				}else if (strcmp(word,SENDFILES)==0){
					maysend = stricmp(equal,"yes")==0;
				}else if (strcmp(word,REQUEST)==0){
					mayrequest = stricmp(equal,"yes")==0;
				}else{
					err += sprintf (err,MSG_U(E_IVLKEYW
						,"Invalid keyword \"%s\"\n")
						,word);
				}
			}else{
				err += sprintf (err,MSG_U(E_IVLKEYPAIR
					,"Invalid keyword value pair\n"
					 "expected an equal sign\n"
					 "\t%s\n")
					,word);
			}
		}
	}
}

static void fputs_cond (
	const char *key,
	const char *val,
	int &first_line,		// Is it the first line we print
	FILE_CFG *fout)
{
	if (val[0] != '\0'){
		if (first_line){
			first_line = 0;
		}else{
			fputs (" \\\n\t",fout);
		}
		fprintf (fout,"%s=%s",key,val);
	}
}

static void fputs_cond (
	const char *key,
	const SSTRING &val,
	int &first_line,		// Is it the first line we print
	FILE_CFG *fout)
{
	fputs_cond (key,val.get(),first_line,fout);
}

/*
	Write one record in the Permissions file
*/
PUBLIC void PERMISSION::write (FILE_CFG *fout)
{
	comment_write (comments,fout);
	int first_line = 1;
	fputs_cond (MACHINE,machine,first_line,fout);
	fputs_cond (LOGNAME,logname,first_line,fout);
	fputs_cond (MYNAME,myname,first_line,fout);
	fputs_cond (COMMANDS,commands,first_line,fout);
	fputs_cond (READ,dirread,first_line,fout);
	fputs_cond (WRITE,dirwrite,first_line,fout);
	fputs_cond (REQUEST,mayrequest ? "yes" : "no",first_line,fout);
	fputs_cond (SENDFILES,maysend ? "yes" : "no",first_line,fout);
	fputc ('\n',fout);
}

PUBLIC PERMISSION *PERMISSIONS::getitem(int no)
{
	return (PERMISSION*)ARRAY::getitem(no);
}

/*
	Locate one machine Permission spec
*/
PUBLIC PERMISSION *PERMISSIONS::getitem(const char *machine, int &no)
{
	int n = getnb();
	PERMISSION *ret = NULL;
	for (int i=no; i<n; i++){
		PERMISSION* p = getitem(i);
		if (p->machine.cmp(machine)==0){
			ret = p;
			no = i+1;
			break;
		}
	}
	return ret;
}

/*
	Locate one machine Permission spec
*/
PUBLIC PERMISSION *PERMISSIONS::getitem(const char *machine)
{
	int no=0;
	return getitem (machine,no);
}

PUBLIC PERMISSIONS::PERMISSIONS()
	: CONFIG_OBJS (f_perms)
{
}

PROTECTED CONFIG_OBJ *PERMISSIONS::newobj (
	const char *buf,	// Buffer to parse from the Permissions file
	const SSTRING &_comments,	// Comments preceding the definition
	char *err)			// Will contain error message or '\0'
{
	return new PERMISSION (buf,_comments,err);
}

PUBLIC void PERMISSIONS::delsystem (const char *system)
{
	while (1){
		PERMISSION *p = getitem (system);
		if (p == NULL) break;
		remove_del (p);
	}
}

