#include <unistd.h>
#include <string.h>
#include "status.h"
#include "popen.h"
#include "status.m"
#include "daemoni.h"
#include <netconf.h>
#include <module_apis/status_apidef.h>

static int sys_command_raw (
	const char *cmd,
	const char *args,
	SSTRINGS &tb)
{
	int ret = -1;
	POPEN pop (cmd,args);
	if (pop.isok()){
		char buf[1000];
		buf[0] = buf[1] = buf[2] = ' ';
		while (pop.wait(10) > 0){
			char tmp[1000];
			while (pop.readout(tmp,sizeof(tmp))!=-1){
				str_exptab (tmp,8,buf+3);
				tb.add (new SSTRING(buf));
			}
		}
		ret = 0;
	}else{
		xconf_error (MSG_U(E_CANTEXEC,"Can't execute the command\n%s"),cmd);
	}
	return ret;
}

int sys_command (
	const char *cmd,
	const char *args,
	SSTRINGS &tb)
{
	int ret = -1;
	const char *path = cmd;
	if (path[0] != '/'){
		DAEMON_INTERNAL *dae = daemon_find (cmd);
		if (dae == NULL){
			path = NULL;
		}else{
			path = dae->getpath();
		}
	}
	if (path != NULL){
		char title[PATH_MAX+100];
		snprintf (title,sizeof(title)-1
			,"%s: %s %s",MSG_U(I_OUTPUT,"Output of command")
			,path,args);
		tb.add (new SSTRING(title));
		ret = sys_command_raw (cmd,args,tb);
	}
	return ret;
}


static int sys_showfile (
	const char *file,
	SSTRINGS &tb)
{
	char title[PATH_MAX+100];
	snprintf (title,sizeof(title)-1,"%s %s",MSG_U(I_FILE,"File"),file);
	tb.add (new SSTRING(title));
	return sys_command_raw ("cat",file,tb);
}

/*
	Display the output of a command in a text box
*/
void sys_command_title (
	const char *title,
	const char *cmd,
	const char *args)
{
	SSTRINGS tb;
	if (sys_command (cmd,args,tb) != -1){
		dialog_textbox (title,tb);
	}
}

/*
	Split a space delimited record and reformat it using one tab as delimiter
*/
static void sys_space2tab(SSTRING *line, SSTRING &a, SSTRING &b)
{
	line->strip_end();
	SSTRINGS tb;
	int nb = str_splitline (line->get(),' ',tb);
	if (nb > 0){
		a.setfrom (tb.getitem(0)->get());
		b.setfrom ("");
		for (int i=1; i<nb; i++){
			const char *s = tb.getitem(i)->get();
			if (b.is_filled()){
				b.appendf("\t%s",s);
			}else{
				b.setfrom (s);
			}
		}
	}
}

static void sys_show_col(
	const char *title,
	const SSTRINGS &tb,		// Title, heading, data
	const char *head,
	int datastart)
{
	DIALOG_RECORDS dia;
	if (head != NULL){
		dia.newf_head ("",head);
	}else{
		SSTRING a,b;
		sys_space2tab(tb.getitem(datastart-1),a,b);
		a.appendf ("\t%s",b.get());
		dia.newf_head ("",a.get());
	}
	for (int i=datastart; i<tb.getnb(); i++){
		SSTRING a,b;
		sys_space2tab(tb.getitem(i),a,b);
		dia.new_menuitem (a.get(),b.get());
	}
	int nof = 0;
	dia.editmenu (title,tb.getitem(0)->get(),help_nil,nof,0);
}

/*
	Display the output of a command in a table.
	We assume the first line produced by the command is the heading
*/
void sys_command_title_col (
	const char *title,
	const char *cmd,
	const char *args,
	const char *head,
	int datastart)
{
	SSTRINGS tb;
	if (sys_command (cmd,args,tb) != -1){
		if (tb.getnb() < 2){
			xconf_error (MSG_U(E_CMDFAIL,"%s\nThe command %s failed"),title,cmd);
		}else{
			sys_show_col (title,tb,head,datastart);
		}
	}
}



void sys_memory_show()
{
	sys_command_title_col (MSG_R(M_MEMORY),"free",""
		,MSG_U(H_MEMORY,"\ttotal\tused\tfree\tshared\tbuffers\tcached")
		,2);
}

void sys_disk_show()
{
	sys_command_title_col (MSG_R(M_DISK),"df","",NULL,2);
}

void sys_scsi_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/scsi/scsi",tb) != -1){
		dialog_textbox (MSG_R(M_SCSI),tb);
	}
}

void sys_md_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/mdstat",tb) != -1){
		dialog_textbox (MSG_R(M_MD),tb);
	}
}

void sys_inter_show()
{
	sys_command_title (MSG_R(M_INTERFACE),"ifconfig","");
}

void sys_iprouting_show()
{
	sys_command_title_col (MSG_R(M_IPROUTING),"route","-n",NULL,3);
}

void sys_ipxrouting_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/net/ipx_route",tb) != -1){
		dialog_textbox (MSG_R(M_IPXROUTING),tb);
	}
}

void sys_interrupts_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/interrupts",tb) != -1){
		sys_show_col (MSG_R(M_INTERRUPTS),tb,MSG_U(H_INTERRUPTS,"Interrupt #\tCounter\tDriver"),2);
	}
}

void sys_ioports_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/ioports",tb) != -1){
		// We overwrite the : in each line with a space so
		// sys_show_col works properly.
		for (int i=2; i<tb.getnb(); i++){
			SSTRING *ss = tb.getitem(i);
			const char *s = ss->get();
			char tmp[strlen(s)+1];
			strcpy (tmp,s);
			char *pt = strchr(tmp,':');
			if (pt != NULL) *pt = ' ';
			ss->setfrom (tmp);
		}
		sys_show_col (MSG_R(M_IOPORTS),tb,MSG_U(H_IOPORTS,"Address\t\tDevice"),2);
	}
}

void sys_sysinfo_show()
{
	SSTRINGS tb;
	SSTRING *ver = new SSTRING;
	ver->setfromf ("Linuxconf %s",PACKAGE_REV);
	tb.add (ver);
	SSTRING *name = new SSTRING;
	char hostname[PATH_MAX];
	if (gethostname(hostname,sizeof(hostname)-1)==-1){
		hostname[0] = '\0';
	}
	name->setfromf (MSG_U(I_HOSTNAMEIS,"Host name: %s"),hostname);
	tb.add (name);
	
	sys_showfile ("/proc/version",tb);
	sys_command  ("uptime","",tb);
	sys_showfile ("/proc/cpuinfo",tb);
	dialog_textbox (MSG_R(M_SYSINFO),tb);
}

void sys_processes_show ()
{
	sys_command_title (MSG_R(M_PROCESSES),"pstree","");
}

void sys_pci_show()
{
	SSTRINGS tb;
	if (kernel_newer (2,2,0)
		&& daemon_findpath ("lspci")!=NULL){
		if (sys_command  ("lspci","-v",tb) != -1){
			dialog_textbox (MSG_R(M_PCI),tb);
		}
	}else if (sys_showfile ("/proc/pci",tb) != -1){
		dialog_textbox (MSG_R(M_PCI),tb);
	}
}

void sys_modules_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/modules",tb) != -1){
		sys_show_col (MSG_R(M_MODULES),tb
			,MSG_U(H_MODULES,"Module\tSize\tUsage\tStatus/Dependancies")
			,1);
	}
}

static void sys_showfile_title (const char *title, const char *path)
{
	SSTRINGS tb;
	if (sys_showfile (path,tb) != -1){
		dialog_textbox (title,tb);
	}
}


void *status_api_get ()
{
	STATUS_API *api = new STATUS_API;
	api->showcommand = sys_command_title;
	api->showfile = sys_showfile_title;
	return api;
}

void status_api_release (void *api)
{
	delete (STATUS_API*)api;
}

