#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static struct PyMethodDef lcconst_methods[] = {
	{NULL, NULL}
};

#define ADD(x) { PyDict_SetItemString(d,#x,PyInt_FromLong(x)); }

extern "C" void
initlcconst()
{
	PyObject *m, *d;
	m = Py_InitModule("lcconst", lcconst_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("", "lcconst.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcconst");

	/* dialog_def.h */
	ADD(DIATYPE_STD)
	ADD(DIATYPE_ERROR)
	ADD(DIATYPE_NOTICE)
	ADD(DIATYPE_POPUP)
	ADD(DIATYPE_MENUPOPUP)
	ADD(MENU_UNKNOWN)
	ADD(MENU_NETWORK_CLIENT)
	ADD(MENU_NETWORK_SERVER)
	ADD(MENU_NETWORK_MISC)
	ADD(MENU_NETWORK_BOOT)
	ADD(MENU_MAIN_CONFIG)
	ADD(MENU_MAIN_CONTROL)
	ADD(MENU_CTRL_FILE)
	ADD(MENU_USER_STD)
	ADD(MENU_USER_SPC)
	ADD(MENU_USER_POLICIES)
	ADD(MENU_USER_ALIAS)
	ADD(MENU_CONTROL_PANEL)
	ADD(MENU_LOGS)
	ADD(MENU_NETWORK_FIREWALL)
	ADD(MENU_SYS_STATUS)
	ADD(MENU_MAILCONF)
	ADD(MENU_MISCSERV)
	ADD(MENU_FSCONF)
	ADD(MENU_MAIN_STATUS)
	ADD(MENU_GURUS)
	ADD(MENU_BOOT)
	ADD(MENUBUT_SAVE)
	ADD(MENUBUT_ADD)
	ADD(MENUBUT_DEL)
	ADD(MENUBUT_INS)
	ADD(MENUBUT_OK)
	ADD(MENUBUT_ACCEPT)
	ADD(MENUBUT_CANCEL)
	ADD(MENUBUT_QUIT)
	ADD(MENUBUT_YES)
	ADD(MENUBUT_NO)
	ADD(MENUBUT_EDIT)
	ADD(MENUBUT_RESET)
	ADD(MENUBUT_MORE)
	ADD(MENUBUT_USR1)
	ADD(MENUBUT_USR2)
	ADD(MENUBUT_USR3)
	ADD(MENUBUT_USR4)
	ADD(MENUBUT_USR5)
	ADD(MENUBUT_USR6)
	ADD(MENUBUT_USR7)
	ADD(DIALOG_CURSES)
	ADD(DIALOG_HTML)
	ADD(DIALOG_GUI)
	ADD(DIALOG_SILENT)
	ADD(DIALOG_TREE)
	ADD(DIALOG_TREEJMP)
	ADD(DIALOG_GET)
	ADD(DIALOG_SET)
	ADD(DIAGUI_AUTO)
	ADD(DIAGUI_GUI)
	ADD(DIAGUI_NOGUI)
	ADD(MENU_NULL)
	ADD(MENU_ESCAPE)
	ADD(MENU_CANCEL)
	ADD(MENU_QUIT)
	ADD(MENU_SAVE)
	ADD(MENU_OK)
	ADD(MENU_ACCEPT)
	ADD(MENU_DEL)
	ADD(MENU_INS)
	ADD(MENU_ADD)
	ADD(MENU_YES)
	ADD(MENU_NO)
	ADD(MENU_EDIT)
	ADD(MENU_RESET)
	ADD(MENU_INTERNAL_TIMEOUT)
	ADD(MENU_HELP)
	ADD(MENU_MORE)
	ADD(MENU_USR1)
	ADD(MENU_USR2)
	ADD(MENU_USR3)
	ADD(MENU_USR4)
	ADD(MENU_USR5)
	ADD(MENU_USR6)
	ADD(MENU_USR7)
	ADD(MENU_CUT)
	ADD(MENU_MESSAGE)
	ADD(HTML_KEY_FULL)
	ADD(HTML_KEY_TAG)
	ADD(HTML_KEY_INDEX)
	ADD(GUI_H_LEFT)
	ADD(GUI_H_CENTER)
	ADD(GUI_H_RIGHT)
	ADD(GUI_V_TOP)
	ADD(GUI_V_CENTER)
	ADD(GUI_V_BOTTOM)
	/* configf.h */
	ADD(CONFIGF_NONE)
	ADD(CONFIGF_MANAGED)
	ADD(CONFIGF_PRIVATE)
	ADD(CONFIGF_OPTIONAL)
	ADD(CONFIGF_GENERATED)
	ADD(CONFIGF_PROBED)
	ADD(CONFIGF_ERASED)
	ADD(CONFIGF_SIGNPOUND)
	ADD(CONFIGF_NOARCH)
	ADD(CONFIGF_VIRTUAL)
	ADD(CONFIGF_DIST)
	ADD(CONFIGF_TMPLOCK)
	ADD(CONFIGF_FIXEDBASE)
	/* netconf_def.h */
	ADD(NETLOG_REQ)
	ADD(NETLOG_ERR)
	ADD(NETLOG_OUT)
	ADD(NETLOG_VERB)
	ADD(NETLOG_CMD)
	ADD(NETLOG_TITLE)
	ADD(NETLOG_SECTION)
	ADD(NETLOG_DONTDO)
	ADD(NETLOG_WHY)
}
