/* this is the queue manager */

#include <stdlib.h>
#include <string.h>
#include "printer.h"
#include "printer.m"
#include <private_msg.h>
#include <userconf.h>

#include "deez_parser.h"
#include "printer_cfile.h"
#include "printer_common_data.h"

#if 0
void list_current_queue_state(const char *which_one)
{
    DIALOG_TEXTBOX dia_queinfo;
    char my_buff[2048];
    char tempy[TYPICAL_STRING_SIZE];
    int  my_selection;
    SSTRINGS my_text;

    sprintf(tempy, "lpq -P%s", which_one);
    execute_proggy_and_get_stdout(tempy, my_buff, 2000);

    {
        char *where_to_zero;
        char *where_to_read_from;

        where_to_read_from=&my_buff[0];
        where_to_zero=strchr(where_to_read_from, '\n');
        while((*where_to_read_from)&&where_to_zero){
            *where_to_zero=0;
            my_text.add(new SSTRING(where_to_read_from));
            where_to_read_from=where_to_zero+1;
            where_to_zero=strchr(where_to_read_from, '\n');
        }
    }

    if(!strcmp(my_buff, "no entries\n"))
        strcpy(my_buff, MSG_U(M_QMGRNOJOBS, "There are no jobs for this queue.\n"));
    dia_queinfo.newf_text("", my_text);
    sprintf(tempy, MSG_U(M_QMGRJOBSLISTINGFOR, "Jobs listing for %s"), which_one);
    dia_queinfo.edit(tempy, MSG_U(M_QMGROUTPUTLPQ, "Output from the lpq command:"), help_nil, my_selection, MENUBUT_QUIT);
}
#endif

void edit_specified_queue(const char *which_one, const char *str_for_all)
{
    int    my_selection;

    my_selection=0;
    DIALOG_MENUPOPUP dia_queopts;

    MENU_STATUS    my_button;
    char   my_titletx[TYPICAL_STRING_SIZE];
    char   my_header_text[1024];
    char   my_command_line[TYPICAL_STRING_SIZE];
    char   *my_queue_report;
    char   my_added_particle[TYPICAL_STRING_SIZE]; /* particle to add to command if a specific printer is edited */
    char   my_added_particle2[TYPICAL_STRING_SIZE];

    dia_queopts.remove_all();

    strcpy(my_header_text, MSG_U(M_QMGRQSTATUSREP, "Queue status report:\n"));
    my_queue_report=&my_header_text[0];
    my_queue_report+=strlen(my_queue_report);

    if(!strcmp(which_one, str_for_all)){
        strcpy(my_added_particle, " all");
        sprintf(my_titletx, MSG_U(M_QMGRMNGALLPRTQUEUE, "Managing all printers' queue"));
    } else {
        sprintf(my_added_particle, " %s", which_one);
        sprintf(my_titletx, MSG_U(M_QMGRMNTHATQUEUE, "Managing queue %s"), which_one);
    }
    sprintf(my_added_particle2, "%s >/dev/null", my_added_particle);
    sprintf(my_command_line, "lpc status%s", my_added_particle);
    execute_proggy_and_get_stdout(my_command_line, my_queue_report, 1023-strlen(&my_header_text[0]));

    dia_queopts.new_menuitem("", MSG_U(M_QMGRENEVTHING, "Enable everything (services fully operational)"));
    dia_queopts.new_menuitem("", MSG_U(M_QMGRENQUEUE, "Enable queueing"));
    dia_queopts.new_menuitem("", MSG_U(M_QMGRENPRINT, "Enable printing"));
    dia_queopts.newf_title(" ", "");
    dia_queopts.new_menuitem("", MSG_U(M_QMGRDISEVTHING, "Disable everything (services fully stopped)"));
    dia_queopts.new_menuitem("", MSG_U(M_QMGRDISQUEUE, "Disable queueing (jobs previously issued will be printed)"));
    dia_queopts.new_menuitem("", MSG_U(M_QMGRDISPRINT, "Disable printing (waits for the current job to finish)"));
    dia_queopts.newf_title(" ", "");
    dia_queopts.new_menuitem("", MSG_U(M_QMGRSTOPIMMED, "Stop immediately (aborts even the current job)"));
    dia_queopts.new_menuitem("", MSG_U(M_QMGRSTOPIMREMOVJOBS, "Stop immediately and remove all jobs from the queue"));
    dia_queopts.newf_title(" ", "");
    dia_queopts.new_menuitem("", MSG_U(M_QMGRLISTJOBSBT, "List jobs"));
    dia_queopts.new_menuitem("", MSG_U(M_QMGRRESTARTDAEMON, "Restart printer daemon"));

    /* adds extra [newline] to queue report string (last line could be ommited without this) */
    my_queue_report=&my_header_text[0];

    my_button=dia_queopts.editmenu(my_titletx, my_selection);
    if((my_button==MENU_QUIT)||(my_button==MENU_ESCAPE)){
        return;
    }
	PRIVILEGE *priv = queue_lookuppriv(which_one);
	if (perm_access (priv,MSG_U(P_MNGPRINT,"manage printer queues"))){
		PRIVILEGE *old = perm_setdefprivi(priv);
	    switch(my_selection){
	    case 0:
                strcpy(my_command_line, "lpc enable");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
                strcpy(my_command_line, "lpc start");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
	        break;
	    case 1:
	        strcpy(my_command_line, "lpc enable");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
	        break;
	    case 2:
	        strcpy(my_command_line, "lpc start");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
	        break;
	    case 4:
	        strcpy(my_command_line, "lpc disable");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
	        strcpy(my_command_line, "lpc stop");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
	        break;
	    case 5:
	        strcpy(my_command_line, "lpc disable");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
	        break;
	    case 6:
	        strcpy(my_command_line, "lpc stop");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
	        break;
	    case 8:
	        strcpy(my_command_line, "lpc abort");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
	        break;
	    case 9:
	        if(confirm_yesno_window(MSG_U(M_QMGRSTOPCLEARTT, "Stopping printer and clearing queue"), MSG_U(M_QMGRSTOPCLEARTX, "You are going to stop the printer completely and\nerase its entire queue.\n\nSure you want to proceed?"))){
	            strcpy(my_command_line, "lpc abort");
	            strcat(my_command_line, my_added_particle2);
	            just_executes_the_proggy(my_command_line);
	            sprintf(my_command_line, "lprm -P%s - >/dev/null", which_one);
	            just_executes_the_proggy(my_command_line);
	        }
	        break;
	    case 11:
	        queue_jobs (which_one);
	        break;
	    case 12:
	        strcpy(my_command_line, "lpc restart");
	        strcat(my_command_line, my_added_particle2);
	        just_executes_the_proggy(my_command_line);
	        break;
	    }
		perm_setdefprivi(old);
	}
}

/* same as queue_getstat(...) but for lprng */
void queue_getstat_lprng (
	const char *p,		// Printer or queue name
	bool &accept,
	bool &print,
	int &nbjob)			// Number of jobs in the spool
{
    SSTRING command_line_to_send;
    char my_buff[1024];
    char *my_pos;

    accept=false;
    print=false;
    nbjob=0;

    command_line_to_send.setfromf("lpc status %s", p);
    execute_proggy_and_get_stdout(command_line_to_send.get(), my_buff, 1024);
    if((my_pos=strchr(my_buff, '\n'))){
        SSTRING found_word;
        my_pos++;

//        printf("my_pos: [%s]\n", my_pos);

        gimme_word_from_string(my_pos, found_word, 1); // printing
//        printf("returned 1: [%s]\n", found_word.get());
        if(!(strcmp(found_word.get(), "enabled")))
            print=true;

        gimme_word_from_string(my_pos, found_word, 2); // spooling
//        printf("returned 2: [%s]\n", found_word.get());
        if(!(strcmp(found_word.get(), "enabled")))
            accept=true;

        gimme_word_from_string(my_pos, found_word, 3); // total jobs
//        printf("returned 3: [%s]\n", found_word.get());
        nbjob=atoi(found_word.get());
    }
}

void queue_main_window(void)
{
    DIALOG_RECORDS     dia_queequeg;
//	dia_queequeg.newf_head("", MSG_U(M_QMGRQUEUESPRESENT, "Queue name\tPrinter type\tLocation\tQueuing\tPrinting\tJobs"));
    dia_queequeg.newf_head("", MSG_U(M_QMGRQUEUESPRESENTLITE, "Queue name\tQueuing\tPrinting\tJobs"));
    int  my_selection=0;
    const char *str_every_one = MSG_U(M_QMGRALLQUEUES, "all queues");
    PRIVATE_MESSAGE timer;
    dialog_settimer (timer,3,true);		// Refresh the list every 3 seconds
    dia_queequeg.waitfor (timer);

    while(1){
                SSTRINGS queues;
		queue_getlist (queues);
		//  dia_queequeg.new_menuitem(str_every_one, "");

		queues.sort();
		int nb = queues.getnb();
		for (int i=0; i<nb; i++){
			const char *q = queues.getitem(i)->get();
			bool accept,print;
                        int nbjob;
                        if(kind_of_lpr_system_installed==LPRTYPE_LPRNG){
                            queue_getstat_lprng (q, accept, print, nbjob);
                        }else{
                            queue_getstat (q,accept,print,nbjob);
                        }
			char line[100];

                        snprintf (line, sizeof(line)-1, "%s\t%s\t%d"
                                ,accept ? MSG_U(I_YES, "Yes") : MSG_U(I_NO,"No")
				,print  ? MSG_R(I_YES) : MSG_R(I_NO)
				,nbjob);

                        dia_queequeg.set_menuitem(i, q, line);
                }
		dia_queequeg.remove_last (nb+1);

		MENU_STATUS my_button=dia_queequeg.editmenu(MSG_U(M_QMGRQUEUEMGRTT, "Queue manager"), MSG_U(M_QMGRQUEUEMGRTX, "Select the queue you want to manage."), my_queuemgrmain_helpfile, my_selection, MENUBUT_QUIT);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
		case MENU_MESSAGE:
			// do nothing, let the list refresh itself
			break;
        default:
            if(nb > 0){
                /* edit specified queue */
                const char *queue = queues.getitem(my_selection)->get();
                edit_specified_queue(queue, str_every_one);
            }
            break;
        }
	}
	dialog_deltimer (timer);
}


