/* this configures the hosts authorized to use the local queues */

#include <stdlib.h>
#include <string.h>
#include "printer.h"
#include "printer.m"
#include "deez_parser.h"
#include "printer_cfile.h"
#include "printer_common_data.h" // not used currently

// #define HOSTSLPD_FILENAME "/etc/hosts.lpd"

/* edit some host authorized to use this computer's printers */
void edit_whocanuse_myprinters(char *new_data_string, int given_max_strsize)
{
    DIALOG  dia_edtwho;
    MENU_STATUS     my_button=(MENU_STATUS)0;
    int     my_selection=0;

    dia_edtwho.newf_str(MSG_U(M_AUTHHOSTNMEDSTR, "Hostname:"), new_data_string, given_max_strsize-1);

    my_button=dia_edtwho.editmenu(MSG_U(M_AUTHHNEDTT, "Editing hostname"), MSG_U(M_AUTHHNEDTX, "Type the name of the host you want\nto grant access to your printer(s)."), help_nil, my_selection, MENUBUT_QUIT|MENUBUT_DEL|MENUBUT_ACCEPT);

    switch(my_button){
    case MENU_DEL:
        *new_data_string=0;
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    default:
        return;
    }
}

/* add a new host authorized to use this computer's printers */
void add_whocanuse_myprinters(char *new_data_string, int given_max_strsize)
{
    DIALOG  dia_addwho;

    dia_addwho.newf_str(MSG_U(M_AUTHHNADSTR, "Hostname:"), new_data_string, given_max_strsize-1);

    dia_addwho.edit(MSG_U(M_AUTHHNADTT, "Adding a new host"), MSG_U(M_AUTHHNADTX, "Type the name of the host you want\nto grant access to your printer(s)."), help_nil);
}

/* which hostnames in my network can use my printers */
void edit_whocanuse_myprinters(void)
{
    DIALOG_RECORDS dia_whocanlist;

    while(1){
    char default_authhost_name[TYPICAL_STRING_SIZE];
    MENU_STATUS  my_button=(MENU_STATUS)0;
    int  my_selection;

    int  new_data_changed;
    char new_data_string[TYPICAL_STRING_SIZE];

    FILE_CFG *my_file;
    char *my_buff=NULL;
    int  myfilesize;
    int  its_ok=0;

    if(!cf_hostslpdfile.exist())
        cf_hostslpdfile.create();
//    if(!this_file_exists(HOSTSLPD_FILENAME)){
//        if((my_file=fopen(HOSTSLPD_FILENAME, "w"))){
//            fclose(my_file);
//        }
//    }

//    if((my_file=fopen(HOSTSLPD_FILENAME, "r"))){
    if((my_file=cf_hostslpdfile.fopen("r"))){
        fseek(my_file, 0, SEEK_END);
        myfilesize=ftell(my_file);
        fseek(my_file, 0, SEEK_SET);
        if((my_buff=(char *)malloc(myfilesize+1))){
            *my_buff=0;
            *(my_buff+myfilesize)=0;
            fread(my_buff, myfilesize, 1, my_file);
            /* ok, whole file readen */
            its_ok=1;
        }
//        fclose(my_file);
        cf_hostslpdfile.fclose(my_file);
    }

    if(its_ok){
        int  i;
        char retnd_hostname[500];
//        DIALOG_RECORDS dia_whocanlist;

//        dia_whocanlist.remove_last(0);
        dia_whocanlist.remove_all();

        dia_whocanlist.newf_head("", MSG_U(M_AUTHLSHEAD, "hostnames"));

        i=0;
        while(copy_specific_block(my_buff, "", i++, retnd_hostname)){
            dia_whocanlist.new_menuitem(retnd_hostname, "");
        }
        my_selection=0;
        my_button=dia_whocanlist.editmenu(MSG_U(M_AUTHLSHDTT, "Allowed hostnames"), MSG_U(M_AUTHLSHDTX, "Only these hostnames can remotely access\nthe printers attached to your system.\n\nClick on the hostname to edit or delete it."), my_allowedhosts_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        /* defults to nothing added nor modified */
        /* -1, some string   = data added
         !(x==-1), no string = data erased
         !(x==-1), string    = data modified */
        new_data_string[0]=0;
        new_data_changed=-1;

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            if(my_buff)
                free(my_buff);
            return;
        case MENU_ADD:
            strcpy(default_authhost_name, MSG_U(M_AUTHSUGHSTNAME, "some_host.my_network"));
            strcpy(new_data_string, default_authhost_name);
            add_whocanuse_myprinters(new_data_string, TYPICAL_STRING_SIZE);
            if(!strcmp(default_authhost_name, new_data_string))
                new_data_string[0]=0;
            break;
        default:
            copy_specific_block(my_buff, "", my_selection, new_data_string);
            edit_whocanuse_myprinters(new_data_string, TYPICAL_STRING_SIZE);
            new_data_changed=my_selection;
            break;
        }

//        if((my_file=fopen(hostslpd_filename, "w"))){
        if((my_file=cf_hostslpdfile.fopen("w"))){
            int i;

            i=0;
            while(copy_specific_block(my_buff, "", i, retnd_hostname)){
                if(i!=new_data_changed){
                    strcat(retnd_hostname, "\n");
                    fputs(retnd_hostname, my_file);
                } else {
                    if(new_data_string[0]){
                        strcat(new_data_string, "\n");
                        fputs(new_data_string, my_file);
                    }
                }
                i++;
            }
            if(new_data_changed==-1){
                strcat(new_data_string, "\n");
                fputs(new_data_string, my_file);
            }
//            fclose(my_file);
            cf_hostslpdfile.fclose(my_file);
        }
    }

    if(my_buff)
        free(my_buff);
    }
}
