
#ifndef PRTMOD_COMMON_DATA
/* the defines' table resides here, so the routines considered generic */


/* printer types... */
#define PRT_LOCAL 0
#define PRT_REMOTE 1
#define PRT_SMBWIN 2
#define PRT_NETWARE 3
#define PRT_DIRECT 4

/* maxmimum of printers to be defined */
// #define MAX_PRINTERS 64

#define TYPICAL_STRING_SIZE 100
#define BIG_STRING_SIZE 2000
#define sb_size 100

/* defaults while creating new printers */
#define DEFAULT_PRINTERNAME "lp"
#define DEFAULT_PRTDEVICE "/dev/lp0"
#define DEFAULT_PRTREMOTEQUEUE "lp"
// #define DEFAULT_PRTFULLPATHSMBFILTER "/usr/lib/rhs/rhs-printfilters/smbprint"
#define DEFAULT_PRTSMBDEVICE "/dev/null"
// #define DEFAULT_PRTFULLPATHNCPFILTER "/usr/lib/rhs/rhs-printfilters/ncpprint"
#define DEFAULT_PRTNCPDEVICE "/dev/null"
#define TEST_PRINTER_COMMAND "lpr -P %s /usr/lib/linuxconf/printer/printertest.ps"
#define TEST_PRINTER_COMMAND_ASCII "lpr -P %s /usr/lib/linuxconf/printer/printertest.txt"
#define DEFAULT_VARSPOOLLPD_DIR "/var/spool/lpd"

#define PRTCP_FILE "/etc/printcap"

/* when creating a new filter */
#define FILTERSCRIPT_NAME "filter"

/* when creating a new printcap entry (note that there's some-kind-of support to other paths than /var/spool/lpd but not here!!! -- unlikely to be a problem in future though) */
#define DEFAULT_FILTERSCRIPT_NAME "/var/spool/lpd/%s/filter"
// #define FULLPATH_FOR_SMB_FILTER "/var/spool/lpd/%s/smbprint"
// #define FULLPATH_FOR_NCP_FILTER "/var/spool/lpd/%s/ncpprint"
#define NAME_FOR_SMB_FILTER "smbprint"
#define NAME_FOR_NCP_FILTER "ncpprint"

// #define MASTERFILTER_FULLPATH "/usr/lib/rhs/rhs-printfilters/master-filter"

/* this is used when creating a new printer and its files */
#define DEFAULT_SPOOLDIRS_HOME "/var/spool/lpd"

#define PRINTCAP_LOCATION "/etc/printcap"

// #define PRINTERDB_FILENAME "/usr/lib/rhs/rhs-printfilters/printerdb"

#define DOTCONFIG_FILENAME ".config"

/* this is used for defining lpd running automatically is it wasn't this way previously */
#define KLINKLEV2_FULLPATH "/etc/rc.d/rc2.d/K60lpd"
#define KLINKLEV3_FULLPATH "/etc/rc.d/rc3.d/K60lpd"
#define KLINKLEV4_FULLPATH "/etc/rc.d/rc4.d/K60lpd"
#define KLINKLEV5_FULLPATH "/etc/rc.d/rc5.d/K60lpd"
#define KLINKLEV6_FULLPATH "/etc/rc.d/rc6.d/K60lpd"
#define LPDSCRIPT_TO_LINK "/etc/rc.d/init.d/lpd"
#define SLINKLEV2_FULLPATH "/etc/rc.d/rc2.d/S60lpd"
#define SLINKLEV3_FULLPATH "/etc/rc.d/rc3.d/S60lpd"
#define SLINKLEV4_FULLPATH "/etc/rc.d/rc4.d/S60lpd"
#define SLINKLEV5_FULLPATH "/etc/rc.d/rc5.d/S60lpd"
#define SLINKLEV6_FULLPATH "/etc/rc.d/rc6.d/S60lpd"

#define LPRTYPE_OLD_LPR 1
#define LPRTYPE_LPRNG   2

/* END of defines' stuff */

#include <modapi.h>


extern int kind_of_lpr_system_installed;

struct t_dataprintcap{
        /* effective fields */
        char printer_name[sb_size];

        char af[sb_size];
        int  br;
        char cf[sb_size];
        char df[sb_size];
        int  fc;
        char ff[sb_size];
        int  fo;
        int  fq;
        int  fs;
        char gf[sb_size];
        int  hl;
        int  ic;
        char if_[sb_size];
        char lf[sb_size];
        char lo[sb_size];
        char lp[sb_size];
        int  mx;
        char nd[sb_size];
        char nf[sb_size];
        char of[sb_size];
        int  pc;
        int  pl;
        int  pw;
        int  px;
        int  py;
        char rf[sb_size];
        char rg[sb_size];
        char rm[sb_size];
        char rp[sb_size];
        int  rs;
        int  rw;
        int  sb;
        int  sc;
        char sd[sb_size];
        int  sf;
        int  sh;
        char st[sb_size];
        char tf[sb_size];
        char tr[sb_size];
        char vf[sb_size];
        /* new for LPRng */
        int  lpd_bounce;
};

//t_dataprintcap my_printcap[MAX_PRINTERS];
extern t_dataprintcap *my_printcap;

/* total of block allocated for my_printcap array */
extern int total_printer_entries;

/*
struct t_general_printer_index{
    char devname[100]; // lp, lp1, etc
    int  exists;       // if true, this data is valid
    char type[100];    // local, ncp, etc
} general_printer_index[MAX_PRINTERS];
*/

struct t_general_printer_index{
    char devname[100]; // lp, lp1, etc
    int  exists;       // if true, this data is valid
    char type[100];    // local, ncp, etc
};

extern t_general_printer_index *general_printer_index;

/* picks a 'word between given_chars' from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 is non-empty string returned */
int gimme_word_from_string_bchar(const char *given_string, SSTRING &write_here, int word_number, const char given_separator);

/* change owner and group of a given file/directory */
void change_owner_and_group(char *given_path, char *given_owner, char *given_group);

/* analyses if given string has characters <32 or >127 or |*` and such things */
/* returns true is provided string is invalid (illegal characters present) */
/* if (corrected_version!=NULL), provides the same string but having the illegal characters substituted by _ */
int invalid_string_provided(char *given_string, char *corrected_version);
int invalid_string_provided(char *given_string, char *corrected_version, const char *invalid_ones);

/* dump given text to specified file, returns 0 if successful */
int dump_this_string_to_given_file(char *given_string, char *given_filename, char *given_path);

/* returns true is given filename exists */
int this_file_exists(char *which_file);
int strgname(char *givenstr);

int just_executes_the_proggy(const char *given_command_line);

/* execute command line and gets the string output.
   returns the command returncode, or -1 if failure */
int execute_proggy_and_get_stdout(const char *given_command_line, char *output_buffer, int output_buffer_size);

/* erase all directory's files and, then, the directory itself */
/* (does not remove internal subdirectories) */
/* returns zero if ok, nonzero if unsuccessful */
int zaapboom_directory(char *which_one);

void informational_window(const char *my_title, const char *my_text);

/* loads the pointed .config (if it exists) file and returns the printer type
0- local or remote
PRT_SMBWIN 2
PRT_NETWARE 3
 used because the return_printer_type(N) is not absolutely
 correct while determining SMB or NCP printers */
int return_printer_type_from_generalcfg(char *given_filename);

/* looks at variables and returns the printer type analysing the context */
/* from printcap file */
int return_printer_type(int which_printer);

/* return true if yes, false if no */
int confirm_yesno_window(const char *my_title, const char *my_text);

/* picks a 'word' (string-particle between spaces) from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 if non-empty string returned */
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number);
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number, int to_eol);

/* change_printer_type changes the type (SMB, NCP, DIRECT, LOCAL, REMOTE) */
int change_printer_type(int which_printer, int setto);
int printer_change_printer_type(int which_printer);
int printer_change_printer_name_or_spooldir(int which_printer);

#define PRTMOD_COMMON_DATA
#endif
