/*
	This small utility is used to collect the available memory and the
	swap. For the memory, it sums the free, cached and buffers.

	You must enable the "gauge" feature to have a proper graph
	as those numbers do not grow
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main (int, char *[])
{
	int ret = -1;
	FILE *fin = fopen ("/proc/meminfo","r");
	if (fin != NULL){
		char buf[100];
		int memfree = 0;
		int cached = 0;
		int buffers = 0;
		int swapfree = 0;
		while (fgets (buf,sizeof(buf)-1,fin)!=NULL){
			if (strncmp(buf,"MemFree:",8)==0){
				char *pt = buf+8;
				while (*pt == ' ') pt++;
				memfree = atoi(pt);
			}else if (strncmp(buf,"Cached:",7)==0){
				char *pt = buf+7;
				while (*pt == ' ') pt++;
				cached = atoi(pt);
			}else if (strncmp(buf,"Buffers:",8)==0){
				char *pt = buf+8;
				while (*pt == ' ') pt++;
				buffers = atoi(pt);
			}else if (strncmp(buf,"SwapFree:",9)==0){
				char *pt = buf+9;
				while (*pt == ' ') pt++;
				swapfree = atoi(pt);
			}
		}
		ret = 0;
		printf ("%ld\n%ld\n\nMemory usage\n"
			,(cached+buffers+memfree)*1024l
			,swapfree*1024l);
		fclose (fin);
	}
	if (ret == -1){
		printf ("0\n0\n\nCan't read /proc/loadavg\n");
	}
	return 0;
}



