
#ifndef MC_DEFINE_MACROS

/* load config file to my_vitems */
#define INIT_FILE_NWSERVCONF \
    VIEWITEMS_PARSER pre_my_vitems;\
    VIEWITEMS my_vitems(pre_my_vitems);\
    my_vitems.read(cf_nwservconf)

/* save config file from my_vitems */
#define SAVE_FILE_NWSERVCONF \
    my_vitems.write(cf_nwservconf, 0)

/* used in 'options' settings (stand-alone ones, they don't reflect a item in a list) */

/* provided: varname, group_number, word number, field description */
#define CREATE_STR_FIELD_STANDALONE(a,b,c,d) \
    SSTRING a;\
    load_standalone_vardata(a, my_vitems, b, c);\
    my_dialog.newf_str(d, a)

/* same as CREATE_STR_FIELD_STANDALONE() but replaces the given word by an empty string */
/* provided: varname, group_number, word number, field description */
#define CREATE_STR_FIELD_STANDALONE_SUBS(a,b,c,d,e) \
    SSTRING a;\
    load_standalone_vardata(a, my_vitems, b, c);\
    if(!strcmp(a.get(), e))\
    a.setfrom("");\
    my_dialog.newf_str(d, a)

/* provided: varname, group_number, word_number, which bit to use, field description */
#define CREATE_BIN_CHK_FIELD_STANDALONE(a,d,e,c,b) \
    char a;\
    a=load_standalone_bin_flag(my_vitems, d, e, c);\
    my_dialog.newf_chk("", a, b)

/* provided: varname, list var name, group_number, word number, field description */
#define CREATE_LIST_FIELD_STANDALONE(a,b,e,c,d) \
    SSTRING a;\
    FIELD_LIST *b;\
    load_standalone_vardata(a, my_vitems, e, c);\
    b=my_dialog.newf_list(d, a)




/* used in properties' dialogs (the ones for settings are from listed items) */

/* provided: varname, list var name, word number, field description */
#define CREATE_CBOX_FIELD(a,b,c,d) \
    SSTRING a;\
    FIELD_COMBO *b;\
    gimme_word_from_string(line_storage.get(), a, c);\
    b=my_dialog.newf_combo(d, a)

/* provided: list var name, item */
#define ADD_LIST_ITEM(a,b) \
    a->addopt(b)

/* provided: list var name, item, description */
#define ADD_LIST_ITEM_2(a,b,c) \
    a->addopt(b,c,"")

/* provided: varname, word number, field description */
#define CREATE_STR_FIELD(a,c,d) \
    SSTRING a;\
    gimme_word_from_string(line_storage.get(), a, c);\
    my_dialog.newf_str(d, a)

/* same as CREATE_STR_FIELD but picks from the specified field to the end of line */
/* note that when writting back the error checker must be tolerant to space charactes */
/* provided: varname, word number, field description */
#define CREATE_STR_FIELD_TO_EOL(a,c,d) \
    SSTRING a;\
    gimme_word_from_string(line_storage.get(), a, c, 1);\
    my_dialog.newf_str(d, a)

/* same as CREATE_STR_FIELD but replaces '-' by '' and vice-versa */
/* provided: varname, word number, field description */
#define CREATE_OPT_STR_FIELD(a,c,d) \
    SSTRING a;\
    gimme_word_from_string(line_storage.get(), a, c);\
    empty_is_dash(a, 1);\
    my_dialog.newf_str(d, a)

#define INIT_PROPERTIES_EDITION \
    SSTRING line_storage;\
    parser_load_line(my_vitems, line_storage, which_group, which_item)

#define CLOSE_PROPERTIES_EDITION \
    parser_write_line(my_vitems, line_storage, which_group, which_item)

/* provided: word number */
#define CREATE_BIN_FLAGSHOLDER(c) \
    int my_flags;\
    {\
    SSTRING dang;\
    gimme_word_from_string(line_storage.get(), dang, c);\
    my_flags=hextoi(dang.get()); /* who wants to get some dang.. */ \
    }

/* same as CREATE_BIN_FLAGSHOLDER but reads decimal flags */
/* provided: word number */
#define CREATE_BIN_FLAGSHOLDER_DEC(c) \
    int my_flags;\
    {\
    SSTRING dang;\
    gimme_word_from_string(line_storage.get(), dang, c);\
    my_flags=atoi(dang.get()); /* who wants to get some dang.. */ \
    }

/* if my_flags==0 then the number is not printed at all */
/* provided: word number */
#define DUMP_BIN_FLAGSHOLDER_NOZERO(a) \
    {\
    SSTRING dang;\
    if(my_flags)\
    dang.setfromf("0x%x", my_flags);\
    replace_word(line_storage, dang.get(), a, ILLEGAL_SPACES);\
    }

/* same as CREATE_BIN_FLAGSHOLDER but writes decimal flags */
/* if my_flags==0 then the number is not printed at all */
/* provided: word number */
#define DUMP_BIN_FLAGSHOLDER_NOZERO_DEC(a) \
    {\
    SSTRING dang;\
    if(my_flags)\
    dang.setfromf("%d", my_flags);\
    replace_word(line_storage, dang.get(), a, ILLEGAL_SPACES);\
    }

/* provided: varname, which bit to use, field description */
#define CREATE_BIN_CHK_FIELD(a,c,b) \
    char a;\
    a=get_bit_status(my_flags, c);\
    my_dialog.newf_chk("", a, b)

/* probably these will be only useful for the drives' settings */

/* provided: word number */
#define CREATE_FLAGSHOLDER(c) \
    SSTRING my_flags;\
    gimme_word_from_string(line_storage.get(), my_flags, c);\
    if(!strcmp(my_flags.get(), "-")) \
    my_flags.setfrom("")

/* provided: varname, flag character, field description */
#define CREATE_CHK_FIELD(a,c,b) \
    char a;\
    a=check_charflag(my_flags.get(), c);\
    my_dialog.newf_chk("", a, b)

#define MC_DEFINE_MACROS
#endif

