
/* if is_new_entry!=0 then the 'del' button is not shown */
/* retuns !=0 if user confirmed, ==0 if cancelled or removed the entry */
int section_edit_drives_prop(VIEWITEMS &my_vitems, int which_group, int which_item, int is_new_entry)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;
    int did_user_accept; // 0 user cancelled, !=0 user confirmed

    INIT_PROPERTIES_EDITION;

    /* main */
    my_dialog.newf_title(MSG_U(X_MAIN, "Main"), 1, "", MSG_R(X_MAIN));
    CREATE_STR_FIELD(my_volume,0,MSG_U(F_VOLUMENAME, "Volume name:"));
    CREATE_STR_FIELD(my_dir,1,MSG_U(F_VOLUMEDIRECTORY, "Directory:"));
    /* options */
    my_dialog.newf_title(MSG_U(X_OPTIONS, "Options"), 1, "", MSG_R(X_OPTIONS));
    CREATE_FLAGSHOLDER(2);
    CREATE_CHK_FIELD(myflag_i,'i',MSG_U(X_L_IGNORECASE, "Ignore case"));
    CREATE_CHK_FIELD(myflag_k,'k',MSG_U(X_L_USELOWERCASE, "Use lowercase"));
    CREATE_CHK_FIELD(myflag_m,'m',MSG_U(X_L_REMOVABLEVOLUME, "Removable volume"));
    CREATE_CHK_FIELD(myflag_n,'n',MSG_U(X_L_NOFIXEDINODES, "No fixed inodes (CD-ROM, DOS-volumes)"));
    CREATE_CHK_FIELD(myflag_o,'o',MSG_U(X_L_ONLYONEFSINODENS, "Volume has only one filesystem/device/namespace"));
    CREATE_CHK_FIELD(myflag_p,'p',MSG_U(X_L_PIPEFS, "\"PIPE\"-filesystem"));
    CREATE_CHK_FIELD(myflag_r,'r',MSG_U(X_L_VOLISREADONLY, "Volume is read-only, reports 0 bytes free"));
    CREATE_CHK_FIELD(myflag_t,'t',MSG_U(X_L_VOLHASTRUSTEES, "Volume has trustees"));
    CREATE_CHK_FIELD(myflag_T,'T',MSG_U(X_L_VOLHASTRUSTEESBUT, "Volume has trustees but ignore Un*x rights"));
    CREATE_CHK_FIELD(myflag_O,'O',MSG_U(X_L_OS2NAMESPACE, "OS/2 namespace (useful for Win95 clients)"));
    CREATE_CHK_FIELD(myflag_N,'N',MSG_U(X_L_NFSNAMESPACE, "NFS namespace"));
    /* permissions */
    my_dialog.newf_title(MSG_U(X_PERMISSIONS, "Permissions"), 1, "", MSG_R(X_PERMISSIONS));
    CREATE_STR_FIELD(my_permdirs,3,MSG_U(F_MASK4DIRS, "Mask for directories (opt.):"));
    CREATE_STR_FIELD(my_permfiles,4,MSG_U(F_MASK4FILES, "Mask for files (opt.):"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        if(is_new_entry){
            my_button=my_dialog.edit(MSG_U(T_CREATINGNEWVOL, "Creating new volume..."), "", hf_volume_props, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);
        }else{
            my_button=my_dialog.edit(MSG_U(T_EDITINGVOL, "Editing volume..."), "", hf_volume_props, my_selection, MENUBUT_ACCEPT|MENUBUT_DEL|MENUBUT_QUIT);
        }

        did_user_accept=0;
        switch(my_button){
        case MENU_DEL:
            if(askuser_for_deletion()){
                parser_remove_line(my_vitems, which_group, which_item);
                SAVE_FILE_NWSERVCONF;
                return(0);
            }
            illegal_entry_found=1;
            break;
        case MENU_ACCEPT:
            did_user_accept=1;

            /* check if first drive is 'SYS' as it should.. */
            if((strcmp(my_volume.get(), "SYS"))&&(!which_item)){
                warnuser_with_this(MSG_U(T_FIRSVOLNOTSYS, "First volume not called \"SYS\""), MSG_U(N_FIRSTVOLNOTSYS, "The first volume must be SYS!"));
                illegal_entry_found=1;
                break;
            }

            /* check if there are duplicate entries for drive's name.. */
            if(check_if_duplicated_entry(my_vitems, my_volume.get(), which_group, which_item, 0)){
                warnuser_duplicated_entry();
                illegal_entry_found=1;
                break;
            }

            /* main */
            illegal_entry_found|=replace_word(line_storage, my_volume.get(), 0, ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|UPPERCASE_ONLY);
            illegal_entry_found|=replace_word(line_storage, my_dir.get(), 1, ILLEGAL_SPACES|ILLEGAL_EMPTYNESS);
            /* flags */
            set_charflag(my_flags, 'i', myflag_i);
            set_charflag(my_flags, 'k', myflag_k);
            set_charflag(my_flags, 'm', myflag_m);
            set_charflag(my_flags, 'n', myflag_n);
            set_charflag(my_flags, 'o', myflag_o);
            set_charflag(my_flags, 'p', myflag_p);
            set_charflag(my_flags, 'r', myflag_r);
            set_charflag(my_flags, 't', myflag_t);
            set_charflag(my_flags, 'T', myflag_T);
            set_charflag(my_flags, 'O', myflag_O);
            set_charflag(my_flags, 'N', myflag_N);
            if(!(*my_flags.get())) // don't let it be empty, put '-' instead
                my_flags.setfrom("-");
            replace_word(line_storage, my_flags.get(), 2, 0);
            /* permissions */
            illegal_entry_found|=replace_word(line_storage, my_permdirs.get(), 3, ILLEGAL_SPACES|UPPERCASE_ONLY|DIGITS_ONLY);
            illegal_entry_found|=replace_word(line_storage, my_permfiles.get(), 4, ILLEGAL_SPACES|DIGITS_ONLY);

            if(!illegal_entry_found){
                CLOSE_PROPERTIES_EDITION;
                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
    return(did_user_accept);
}

void section_edit_drives(void)
{
    INIT_FILE_NWSERVCONF;

    DIALOG_RECORDS my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int which_group=1;

    my_dialog.newf_head("", MSG_U(X_VOLNAME_DIRECTORY, "volume name\tdirectory"));

    while(1){
        insert_to_dialog_records(my_dialog, my_vitems, which_group, 0, 1);

        my_selection=0;
        my_button=my_dialog.editmenu(MSG_U(T_DEFINEDVOLUMES, "Defined volumes"), "", help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            /* adds item, but if used does not confirm the properties' window the item is removed */
            if(!section_edit_drives_prop(my_vitems, which_group, parser_add_line(my_vitems, MSG_U(X_VOLNAME_SOMEDIRECTORY, "VOLUME_NAME\t/some/directory/"), which_group), 1)){
                my_vitems.remove_all();
                my_vitems.read(cf_nwservconf);
            }
            break;
        default:
            section_edit_drives_prop(my_vitems, which_group, my_selection, 0);
            break;
        }
    }
}
