#pragma implementation
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <translat.h>
#include "ircdconf.h"
#include "ircdconf.m"

PUBLIC void dia_conclass(SSTRINGS *tb)
{
    DIALOG dia;
    int ping[8], confreq[8], maxlink[8], ssize[8];
    const char *head[] = {
        MSG_U(I_CC90,"Class: 90, Hubs"),
        MSG_U(I_CC80,"Class: 80, Others"),
        MSG_U(I_CC70,"Class: 70, Others"),
        MSG_U(I_CC50,"Class: 50, Leafs"),
        MSG_U(I_CC10,"Class: 10, locals"),
        MSG_U(I_CC2,"Class: 2, all .com and .net"),
        MSG_U(I_CC1,"Class: 1, everybody"),
    };
    for(int count=0;count<7;count++)
    {
        ping[count]=0;
        confreq[count]=0;
        maxlink[count]=0;
        ssize[count]=0;
//        dia.newf_head("", head[count]);
        dia.newf_title(head[count], 1, "", head[count]);
        dia.newf_num(MSG_U(F_CCPF,"Ping Frequency"), ping[count]);
        dia.newf_num(MSG_U(F_CCCF,"Connection Frequency"), confreq[count]);
        dia.newf_num(MSG_U(F_CCML,"Maximum Links"), maxlink[count]);
        dia.newf_num(MSG_U(F_CCSS,"Send Quote Size"), ssize[count]);
    }
    while(1)
    {
        SSTRINGS *temp_tb;
        temp_tb = cat_opts("Yy", tb);
        for(int x=0;x<temp_tb->getnb();x++)
        {
            int cl = -1;
            {
                char *ch=get_opt(temp_tb, x, 1);
                int teste = atoi(ch);
                free(ch);
                switch(teste)
                {
                case 90:
                    cl = 0;
                    break;
                case 80:
                    cl = 1;
                    break;
                case 70:
                    cl = 2;
                    break;
                case 50:
                    cl = 3;
                    break;
                case 10:
                    cl = 4;
                    break;
                case 2:
                    cl = 5;
                    break;
                case 1:
                    cl = 6;
                    break;
                }
            }
            {
                char *ch=get_opt(temp_tb, x, 2);
                ping[cl]= atoi(ch);
                free(ch);
            }
            {
                char *ch=get_opt(temp_tb, x, 3);
                confreq[cl]= atoi(ch);
                free(ch);
            }
            {
                char *ch=get_opt(temp_tb, x, 4);
                maxlink[cl]= atoi(ch);
                free(ch);
            }
            {
                char *ch=get_opt(temp_tb, x, 5);
                ssize[cl]= atoi(ch);
                free(ch);
            }
        }
        dia.reload();
        MENU_STATUS menu;
	int nof = 0;
        menu = dia.edit(MSG_R(M_CONCLASS), MSG_U(I_CCDES,"Here you can fine-tune your connections"), help_main, nof, MENUBUT_CANCEL|MENUBUT_ACCEPT);
        if (menu == MENU_ESCAPE||menu == MENU_CANCEL||menu == MENU_QUIT)
            break;
        else
        {
            SSTRINGS new_tb;
            for(int x=0;x<7;x++)
            {
                char ccls[3];
                switch(x)
                {
                case 0:
                    strcpy(ccls,"90");
                    break;
                case 1:
                    strcpy(ccls,"80");
                    break;
                case 2:
                    strcpy(ccls,"70");
                    break;
                case 3:
                    strcpy(ccls,"50");
                    break;
                case 4:
                    strcpy(ccls,"10");
                    break;
                case 5:
                    strcpy(ccls,"2");
                    break;
                case 6:
                    strcpy(ccls,"1");
                    break;
                }
                char line[256];
                sprintf(line, "Y:%s:%d:%d:%d:%d", ccls, ping[x], confreq[x], maxlink[x], ssize[x]);
                new_tb.add(new SSTRING(line));
            }
            if(!cfg_compare(&new_tb,temp_tb))
            {
                change_opts("Yy",tb,&new_tb);
            }
            if(!cfg_compare(tb, &cfg_old))
                savecfg(tb);
            break;
        }
    }
}
