#pragma implementation

#include <stdlib.h>
#include <string.h>
#include <fviews.h>
#include "heartbeatconf.h"
#include "misc.h"
#include "heartbeatconf.m"

void edit_misc()
{
    DIALOG dia;
    SSTRING debugfile, logfile, logfacility, watchdog;
    int keepalive=0, deadtime=0, hopfudge=0, baud=0, udpport=1001;
    //#ifdef __CONECTIVA__
    char nice_failback = 0;
    //#endif
    VIEWITEMS tb;
    tb.read(file_haconf);
    int tb_size = tb.getnb();
    for(int x=0;x<tb_size;x++)
    {
        SSTRING tmp;
        const char *line = str_skip(tmp.copyword(str_skip(tb.getitem(x)->line.get())));
        if(tmp.cmp("debugfile") == 0)
            debugfile.setfrom(line);

        else if(tmp.cmp("logfile") == 0)
            logfile.setfrom(line);

        else if(tmp.cmp("logfacility") == 0)
            logfacility.setfrom(line);

        else if(tmp.cmp("watchdog") == 0)
            watchdog.setfrom(line);

        else if(tmp.cmp("keepalive") == 0)
            keepalive = atoi(line);

        else if(tmp.cmp("deadtime") == 0)
            deadtime = atoi(line);

        else if(tmp.cmp("hopfudge") == 0)
            hopfudge = atoi(line);

        else if(tmp.cmp("baud") == 0)
            baud = atoi(line);

        else if(tmp.cmp("udpport") == 0)
            udpport = atoi(line);
        //#ifdef __CONECTIVA__
        else if(tmp.cmp("nice_failback") == 0){
            tmp.copyword(line);
            if(tmp.cmp("on") == 0)
                nice_failback = 1;
        }
        //#endif
    }
    dia.newf_str(MSG_U(F_DEBUGFILE, "File to write debug messages to: (opt)"), debugfile);
    dia.newf_str(MSG_U(F_LOGFILE, "File to write other messages to: (opt)"), logfile);
    dia.newf_str(MSG_U(F_LOGFACILITY, "Facility to use with syslog/logger: (opt)"), logfacility);
    dia.newf_str(MSG_U(F_WATCHDOG, "The watchdog device: (opt)"), watchdog);
    dia.newf_num(MSG_U(F_KEEPALIVE, "How many seconds between heartbeats: (opt)"), keepalive);
    dia.newf_num(MSG_U(F_DEADTIME, "Time (s) to declare a host dead: (opt)"), deadtime);
    dia.newf_num(MSG_U(F_HOPFUDGE, "For ring topologies, number of hops: (opt)"), hopfudge);
    dia.newf_num(MSG_U(F_BAUD, "Baud rate for both Serial and PPP ports: (opt)"), baud);
    dia.newf_num(MSG_U(F_UDPPORT, "UDP port for communication:"), udpport);
    dia.last_noempty();
    //#ifdef __CONECTIVA__
    dia.newf_chk("", nice_failback, MSG_U(F_NICEFAILBACK, "Nice failback"));
    //#endif
    int nof=0;
    while(1)
    {
        MENU_STATUS menu = dia.edit(MSG_U(T_MISC, "Misc configuration"), "", help_heartbeat, nof);
        if(menu == MENU_ESCAPE || menu == MENU_CANCEL || menu == MENU_QUIT)
            break;
        if(udpport == 0)
            xconf_error(MSG_U(ER_UDPPORT, "The field UDP port MUST NOT be empty!"));
        else if(menu == MENU_ACCEPT){
            for(int x=tb.getnb()-1;x>-1;x--)
            {
                SSTRING tmp;
                tmp.copyword(str_skip(tb.getitem(x)->line.get()));
                if(tmp.cmp("debugfile") == 0)
                    if(strcmp(str_skip(debugfile.get()), "") == 0){
                        tb.remove_del(x);
                    }else{
                        VIEWITEM *item;
                        item = tb.getitem(x);
                        item->line.setfromf("debugfile %s", debugfile.get());
                        debugfile.setfrom("");
                    }
                else if(tmp.cmp("logfile") == 0)
                    if(strcmp(str_skip(logfile.get()), "") == 0)
                        tb.remove_del(x);
                    else{
                        VIEWITEM *item;
                        item = tb.getitem(x);
                        item->line.setfromf("logfile %s", logfile.get());
                        logfile.setfrom("");
                    }
                else if(tmp.cmp("logfacility") == 0)
                    if(strcmp(str_skip(logfacility.get()), "") == 0)
                        tb.remove_del(x);
                    else{
                        VIEWITEM *item;
                        item = tb.getitem(x);
                        item->line.setfromf("logfacility %s", logfacility.get());
                        logfacility.setfrom("");
                    }
                else if(tmp.cmp("watchdog") == 0)
                    if(strcmp(str_skip(watchdog.get()), "") == 0)
                        tb.remove_del(x);
                    else{
                        VIEWITEM *item;
                        item = tb.getitem(x);
                        item->line.setfromf("watchdog %s", watchdog.get());
                        watchdog.setfrom("");
                    }
                else if(tmp.cmp("keepalive") == 0)
                    if(keepalive == 0)
                        tb.remove_del(x);
                    else{
                        VIEWITEM *item;
                        item = tb.getitem(x);
                        item->line.setfromf("keepalive %d", keepalive);
                        keepalive = 0;
                    }
                else if(tmp.cmp("deadtime") == 0)
                    if(deadtime == 0)
                        tb.remove_del(x);
                    else{
                        VIEWITEM *item;
                        item = tb.getitem(x);
                        item->line.setfromf("deadtime %d", deadtime);
                        deadtime = 0;
                    }
                else if(tmp.cmp("hopfudge") == 0)
                    if(hopfudge == 0)
                        tb.remove_del(x);
                    else{
                        VIEWITEM *item;
                        item = tb.getitem(x);
                        item->line.setfromf("hopfudge %d", hopfudge);
                        hopfudge = 0;
                    }
                else if(tmp.cmp("baud") == 0)
                    if(baud == 0)
                        tb.remove_del(x);
                    else{
                        VIEWITEM *item;
                        item = tb.getitem(x);
                        item->line.setfromf("baud %d", baud);
                        baud = 0;
                    }
                else if(tmp.cmp("udpport") == 0)
                    if(udpport == 0)
                        tb.remove_del(x);
                    else{
                        VIEWITEM *item;
                        item = tb.getitem(x);
                        item->line.setfromf("udpport %d", udpport);
                        udpport = 0;
                    }
                //ifdef __CONECTIVA__
                else if(tmp.cmp("nice_failback") == 0)
                    tb.remove_del(x);
                //#endif
            }
            if(strcmp(str_skip(debugfile.get()), "") != 0){
                SSTRING tmp;
                tmp.setfromf("debugfile %s", debugfile.get());
                tb.add(new VIEWITEM(tmp.get()));
            }
            if(strcmp(str_skip(logfile.get()), "") != 0){
                SSTRING tmp;
                tmp.setfromf("logfile %s", logfile.get());
                tb.add(new VIEWITEM(tmp.get()));
            }
            if(strcmp(str_skip(logfacility.get()), "") != 0){
                SSTRING tmp;
                tmp.setfromf("logfacility %s", logfacility.get());
                tb.add(new VIEWITEM(tmp.get()));
            }
            if(strcmp(str_skip(watchdog.get()), "") != 0){
                SSTRING tmp;
                tmp.setfromf("watchdog %s", watchdog.get());
                tb.add(new VIEWITEM(tmp.get()));
            }
            if(keepalive != 0){
                SSTRING tmp;
                tmp.setfromf("keepalive %d", keepalive);
                tb.add(new VIEWITEM(tmp.get()));
            }
            if(deadtime != 0){
                SSTRING tmp;
                tmp.setfromf("deadtime %d", deadtime);
                tb.add(new VIEWITEM(tmp.get()));
            }
            if(hopfudge != 0){
                SSTRING tmp;
                tmp.setfromf("hopfudge %d", hopfudge);
                tb.add(new VIEWITEM(tmp.get()));
            }
            if(baud != 0){
                SSTRING tmp;
                tmp.setfromf("baud %d", baud);
                tb.add(new VIEWITEM(tmp.get()));
            }
            if(udpport != 0){
                SSTRING tmp;
                tmp.setfromf("udpport %d", udpport);
                tb.add(new VIEWITEM(tmp.get()));
            }
            //#ifdef __CONECTIVA__
            else if(nice_failback != 0)
                tb.add(new VIEWITEM("nice_failback on"));
            //#endif
            tb.write(file_haconf, NULL);
            break;
        }
    }
}
