#include <usercomng.h>
#include <dialog.h>
#include "dnsconf.h"
#include "dnsconf.m"
#include "internal.h"
#include <string.h>

class VIRTUAL_COMNG: public USERACCT_COMNG{
	DNS dns;
	PRIMARY prim;
	PRIMARY_EDITINFO info;
	/*~PROTOBEG~ VIRTUAL_COMNG */
public:
	VIRTUAL_COMNG (DICTIONARY&_dict);
	int deluser (PRIVILEGE *);
	int save (PRIVILEGE *priv);
	void setupdia (DIALOG&dia);
	int validate (DIALOG&, int &nof);
	/*~PROTOEND~ VIRTUAL_COMNG */
};

PUBLIC VIRTUAL_COMNG::VIRTUAL_COMNG(
	DICTIONARY &_dict)
	: USERACCT_COMNG (_dict)
{
}


PUBLIC void VIRTUAL_COMNG::setupdia (
	DIALOG &dia)
{
	dia.newf_title (MSG_U(T_MVIRTUAL,"Dns"),1,"",MSG_R(T_MVIRTUAL));
	dia.newf_title (MSG_U(T_BASEINFO,"Basic"),2,"",MSG_R(T_BASEINFO));
	prim.setupdia (dia,dns,2,info);
}	

PUBLIC int VIRTUAL_COMNG::save(
	PRIVILEGE *priv)
{
	int ret = 0;
	return ret;
}

PUBLIC int VIRTUAL_COMNG::validate(
	DIALOG &,
	int &nof)
{
	int ret = 0;
	const char *domain = dict.get_str ("vdomain");
	if (dns.locate_domain (domain)!=NULL){
		xconf_error (MSG_U(E_VHOSTEXIST,"DNS domain %s\n"
			"is already configured"),domain);
		ret = -1;
	}
	return ret;
}

PUBLIC int VIRTUAL_COMNG::deluser (
	PRIVILEGE *)
{
	return 0;
}

USERACCT_COMNG *dnsconf_newcomng(
	const char *key,
	DICTIONARY &dict)
{
	USERACCT_COMNG *ret = NULL;
	if (strcmp(key,"virtual")==0){
		ret = new VIRTUAL_COMNG (dict);
	}
	return ret;
}



