#include <stdio.h>
#include <string.h>
#include "dnsconf.h"
#include "internal.h"

PUBLIC CACHEFILE::CACHEFILE(const char *_domain, const char *_path)
{
	domain.setfrom(_domain);
	path.setfrom (_path);
}

/*
	Get the relative path (name) of the cache file
*/
PUBLIC const char *CACHEFILE::getname()
{
	return path.get();
}
/*
	Get the absolute path of the cache file
*/
PUBLIC void CACHEFILE::abspath(const char *basepath, char *abspath)
{
	const char *p = path.get();
	if (p[0] == '/'){
		strcpy(abspath,p);
	}else{
		sprintf (abspath,"%s/%s",basepath,p);
	}
}

PUBLIC CACHEFILE* CACHEFILES::getitem(int no)
{
	return (CACHEFILE*)ARRAY::getitem(no);
}


/*
	Make sure there is a trailing dot at the end of the string
	if the string already have a dot (seen as a qualified domain name).
	Name without a dot are taken as host name in the current domain.
*/
void dns_cnv2abs(SSTRING &s)
{
	if (s.strchr('.')!=NULL){
		const char *str = s.get();
		int len = strlen(str);
		if (len == 0 || str[len-1] != '.') s.append(".");
	}
}

/*
	Return != 0 if a name is absolute (end with a dot).
*/
int dns_isabs(const char *name)
{
	int ret = 0;
	int len = strlen (name);
	if (len > 0) ret = name[len-1] == '.';
	return ret;
}

/*
	Strip the trailing dot of a name if present
*/
void dns_stripabs(char *name)
{
	int len = strlen (name)-1;
	if (len >= 0 && name[len]) name[len] = '\0';
}


