
#include "aptconf.h"
#include "aptconf.m"

void aptconf_edit()
{
	VLIST vlist;
	SLIST slist;
	DIALOG_MENU dia;

        static const char *m_slist = MSG_U(M_SLIST,"Sources list");
        static const char *m_vlist = MSG_U(M_VLIST,"Vendors list");

	static const char *menuopt[]={
		"", m_slist,
		"", m_vlist,
		NULL
	        };
	
	dia.new_menuitems (menuopt);
	
        int nb = 0;
	
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_APTCONF,"Apt configuration")
			,MSG_U(I_APTCONF,"This menu allows you to configure\nApt options.")
			,help_nil,nb,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_OK){
			const char *key = menuopt[nb*2+1];
			if (key == m_slist){
				aptconf_slist(slist,vlist);
			}else if (key == m_vlist){
				aptconf_vlist(vlist);
			}
		}
	}
}

void aptconf_vlist(VLIST &vlist)
{
	DIALOG_LISTE dia;

	dia.newf_head("",MSG_U(X_TITVLIST,"Vendor\tComment"));
	
        int nb = 0;
	
	while (1){
		int total_vendors = vlist.count();
		for (int i = 0; i < total_vendors; i++){
			VLIST_ITEM vlitem;
			vlist.get(i,vlitem);
			dia.set_menuitem(i,vlitem.vendor.get(),
					 vlitem.comment.get());
		}
		dia.remove_last(total_vendors+1);
		MENU_STATUS code = dia.editmenu (
				MSG_U(T_VLIST,"Vendors list")
				,MSG_U(I_VLIST,
				 "This menu allows you to change and create "
				 "package vendors.")
				,help_nil,nb,MENUBUT_ADD);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_OK){
			aptconf_vlist_edit(vlist,nb);
		}else if (code == MENU_ADD){
			aptconf_vlist_edit(vlist,vlist.count());
		}
	}
}

void aptconf_vlist_edit(VLIST &vlist, int number)
{
	DIALOG dia;
	VLIST_ITEM vlitem;

	vlist.get(number,vlitem);
	
	dia.newf_str(MSG_U(P_VENDOR,"Vendor"),vlitem.vendor);
	dia.newf_str(MSG_U(P_COMMENT,"Comment"),vlitem.comment);
	dia.newf_str(MSG_U(P_FP,"Fingerprint"),vlitem.fp);
	
	int nb = 0;
	
	while (1){
		MENU_STATUS code = dia.edit (
				MSG_U(T_EDVLIST,"Edit vendor")
				,MSG_U(I_EDVLIST,
				 "This menu allows you to change a package vendor.")
				,help_nil,nb
				,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL);
		if (code == MENU_QUIT || code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else if (code == MENU_ACCEPT){
			if (vlitem.check()){
				vlist.set(number,vlitem);
				break;
			}else{
				xconf_error("Can't leave blank fields!");
				if (vlitem.vendor.getlen() == 0){
					nb = 0;
				}else if (vlitem.comment.getlen() == 0){
					nb = 1;
				}else if (vlitem.fp.getlen() == 0){
					nb = 2;
				}
			}
		}else if (code == MENU_DEL){
			vlist.erase(number);
			break;
		}
	}
}

void aptconf_slist(SLIST &slist, VLIST &vlist)
{
	DIALOG_LISTE dia;

	dia.newf_head("",MSG_U(X_TITSLIST,"Type\tURI"));
	
        int nb = 0;
	
	while (1){
		int total_sources = slist.count();
		for (int i = 0; i < total_sources; i++){
			SLIST_ITEM slitem;
			slist.get(i,slitem);
			dia.set_menuitem(i,slitem.type.get(),
					 slitem.uri.get());
		}
		dia.remove_last(total_sources+1);
		MENU_STATUS code = dia.editmenu (
				MSG_U(T_SLIST,"Sources list")
				,MSG_U(I_SLIST,
				 "This menu allows you to change and create "
				 "package sources.")
				,help_nil,nb,MENUBUT_ADD);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_OK){
			aptconf_slist_edit(slist,nb,vlist);
		}else if (code == MENU_ADD){
			aptconf_slist_edit(slist,slist.count(),vlist);
		}
	}
}
void aptconf_slist_edit(SLIST &slist, int number, VLIST &vlist)
{
	DIALOG dia;
	SLIST_ITEM slitem;

	slist.get(number,slitem);
	
	FIELD_COMBO *typecombo = dia.newf_combo(MSG_U(P_TYPE,"Type"),
						slitem.type);
	typecombo->addopt("rpm","RPM Packages");
	typecombo->addopt("rpm-src","RPM Source Packages");
	typecombo->addopt("deb","DEB Packages");
	typecombo->addopt("deb-src","DEB Source Packages");
		
	FIELD_COMBO *vendcombo = dia.newf_combo(MSG_R(P_VENDOR),slitem.vendor);
	vendcombo->addopt("",MSG_U(X_NOVENDOR,"No vendor"));
	int total_vendors = vlist.count();
	for (int i = 0; i < total_vendors; i++){
		VLIST_ITEM vlitem;
		vlist.get(i,vlitem);
		vendcombo->addopt(vlitem.vendor.get(),vlitem.comment.get());
	}
	dia.newf_str(MSG_U(P_URI,"URI"),slitem.uri);
	dia.newf_str(MSG_U(P_DISTR,"Distribution"),slitem.distr);
	dia.newf_str(MSG_U(P_COMP,"Components"),slitem.comp);
	
	int nb = 0;
	
	while (1){
		MENU_STATUS code = dia.edit (
				MSG_U(T_EDSLIST,"Edit source")
				,MSG_U(I_EDSLIST,
				 "This menu allows you to change a package source.")
				,help_nil,nb
				,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL);
		if (code == MENU_QUIT || code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else if (code == MENU_ACCEPT){
			if (slitem.check()){
				slist.set(number,slitem);
				break;
			}else{
				xconf_error("Can't leave Type, Comment nor Distribution blank!");
			}
		}else if (code == MENU_DEL){
			slist.erase(number);
			break;
		}
	}
}
