#include <string.h> /* memset */
#include "internal.h"
#include "apache.m"
#include "keyword.h"

static APACHE_HELP_FILE help_apache ("apache");
static APACHE_HELP_FILE help_mod ("modules");
static APACHE_HELP_FILE help_perf ("performance");
static APACHE_HELP_FILE help_users ("users");

extern CONFIG_FILE httpd_conf;

/* FIXME: Do the mapping like vhosts */

int HTTPD_USERS::cwrite()
{ 
	int ret = -1;
	CONFIG_FILE conf (file.get(),help_nil,CONFIGF_OPTIONAL|CONFIGF_MANAGED);
	FILE_CFG *fp = conf.fopen("w");
	if(fp != NULL) {
		int n = getnb();
		for(int i=0;i<n;i++) { 
			HTTPD_USER *u = getitem(i);
			if(!u->user.is_empty()) { 
				fprintf(fp,"%s:%s\n",u->user.get(),u->pass.get());
			}
		}
		ret = fclose(fp);
	}
	return ret;
}

int HTTPD_AUTHS::edit()
{	
	int ret = -1, nof = 0;

	while (1) {
		DIALOG dia;
		dia.newf_title ("",MSG_U(T_USERFILES,"Users configurations"));
		int n = getnb();
		for(int i=0;i<n;i++) {
			HTTPD_USERS *d = getitem(i);
			if (!d->file.is_empty()) 
				dia.new_menuitem("",d->file);
		}

		MENU_STATUS code = dia.editmenu (MSG_U(T_USERS,
					"Users configurations")
					,MSG_U(I_USERS,"You can configure Apache users/groups\n")
					,help_users
					,nof,0);

		nof--;

        if (code == MENU_ESCAPE || code == MENU_QUIT){
           break;
		}else if(code == MENU_ADD) { 
        }else if (nof < n && nof >= 0){
           ret = editone(nof);
        }

	}
	return ret;
}

PUBLIC int HTTPD_USERS::edit () { 

	int ret = 0, nof = 0; 


	ret = parsehtpasswd((char *)file.get(),*this); 
	
	if(ret == -1) return -1;

	while(1) {
		DIALOG dia;

		int usernum = getnb();

		for(int i=0;i<usernum; i++) {
			dia.new_menuitem("",getitem(i)->user.get());
		}

		dia.setbutinfo (MENU_USR1,MSG_U(B_CHANGEPASS,"Change Password"),"");

		MENU_STATUS code = dia.edit (
			MSG_U(T_APAUSER,"User Configuration")
			,MSG_U(I_APAUSER,"You can configure Apache Users") 
			,help_users
			,nof,MENUBUT_ACCEPT|MENUBUT_USR1|MENUBUT_ADD|MENUBUT_DEL);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			break;
		}else if (code == MENU_ADD){
			HTTPD_USER *u = new HTTPD_USER();
			add(u);		
			u->edit (*this);
		}else if(code == MENU_USR1){ 
			if(getitem(nof)->edit(*this) == 2)
				cwrite();
		}else if(code == MENU_ACCEPT) { 
			cwrite();
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				remove_del(nof);
				ret = 1;
				cwrite();
				break;
			}
		}
	}
	return 0;
}


PUBLIC int HTTPD_USER::edit (HTTPD_USERS &users) { 
	int ret = -1, nof = 0;
	DIALOG dia;
	SSTRING repass, cpass;
	dia.newf_str(MSG_U(F_USER,"Username"),user);
	dia.newf_pass(MSG_U(F_PASS,"Password"),cpass);
	dia.newf_pass(MSG_U(F_REPASS,"Re-type password"),repass);

	while(1) { 
		MENU_STATUS code = dia.edit (
			MSG_U(T_APANAMEPASS,"User name/password")
			,MSG_U(I_APANAMEPASS,"You can configure user name/password") 
			,help_users
			,nof,MENUBUT_CANCEL|MENUBUT_ACCEPT);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			if(stricmp(cpass.get(),repass.get()) != 0)
			// FIXME: Translations
				xconf_error("Passwords dont match\n");
			else {
				pass.setfrom(cryptit((char *)pass.get()));
				return 2;
			}
		}
	}
	return ret;
}

int parsehtpasswd (const char *file, HTTPD_USERS &users)
{  
	char line[100], username[60], password[40];
	if(file == NULL) return -1;
	CONFIG_FILE conf (file,help_nil,CONFIGF_OPTIONAL);
	FILE_CFG *fp = conf.fopen("r");
	if (fp == NULL) return -1;

	users.remove_all();
	while(fgets(line,sizeof(line), fp) != NULL) {
		if(line[0] == '\n') break;
		int i = 0, a = 0;
		while(line[i] != ':') {
			username[i] = line[i];
			i++;
		}
		username[i] = '\0';
		
		i++; /* : */

		while(line[i] != '\n') {
			password[a] = line[i];
			i++, a++;
		}

		password[a] = '\0';
		HTTPD_USER *c = new HTTPD_USER();

		c->user.setfrom(username);
		c->pass.setfrom(password);
		users.add(c);
		
		memset(line,0,sizeof(line));
		memset(username,0,sizeof(username));
		memset(password,0,sizeof(password));
	}
	return 0;
}

PUBLIC int HTTPD_CONFIG::perfedit()
{
	VIEW_MAIN vmain (itemss);
	DIALOG dia;
	VIEWEDIT vedit (vmain,dia);
	int ret = -1;
	int nof = 0;

	dia.newf_title ("",MSG_U(T_NRPROC,"Number of Processes"));

	vedit.newf_num (MSG_U(F_STARTSERVERS,"Start servers"),K_STARTSERVERS);
	vedit.newf_num (MSG_U(F_MAXCLIENTS,"Max clients per servers"),K_MAXCLIENTS);
	vedit.newf_num (MSG_U(F_MAXREQUESTS,"Max requests per child")
		,K_MAXREQUESTSPERCHILD);
	vedit.newf_num (MSG_U(F_MINSPARESERVERS,"Minimum of spare servers")
		,K_MINSPARESERVERS);
	vedit.newf_num (MSG_U(F_MAXSPARESERVERS,"Maximum of spare servers")
		,K_MAXSPARESERVERS);

	dia.newf_title ("",MSG_U(T_KEEPSALIVE,"Keeps Alive"));

	vedit.newf_chk   ("",K_KEEPALIVE,MSG_U(I_KEEPALIVE,"Keep Alive"));
	vedit.newf_num (MSG_U(F_KEEPALIVET,"Keep Alive Timeout")
		,K_KEEPALIVETIMEOUT);
	vedit.newf_num (MSG_U(F_MAXKEEPALIVEREQ,"Max Keep Alive Requests")
				,K_MAXKEEPALIVEREQ);

	dia.newf_title ("",MSG_U(T_ADVTUNING,"Advanced Tuning"));

	vedit.newf_num (MSG_U(F_TIMEOUT,"Time out"),K_TIMEOUT);

	while(1) {
		MENU_STATUS code = dia.edit (
			MSG_U(T_APAPERF,"Apache Performance Tuning")
			,MSG_U(I_APAPERF,"You can configure Apache performance")
			,help_perf
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			vedit.update("");
			write();
			break;
		}
	}
	return ret;
}

PUBLIC int HTTPD_CONFIG::modedit()
{
	int ret = -1;
	DIALOG dia;
	int nof = 0;
	SSTRINGS s_mods;
	VIEWITEMS v_mods;
	v_mods.neverdelete();
	itemss.reset_iter();
	VIEWITEM *it;
	while ((it=itemss.getnext())!=NULL){
		const char *s = it->line.get();
		char word[200];
		const char *pt = str_copyword (word,s,sizeof(word)-1);
		if (strcmp(word,K_LOADMODULE)==0){
			pt = str_skip(pt);
			s_mods.add (new SSTRING(pt));
		}
	}
	while (1){
		int n = s_mods.getnb();
		for(int i=0;i<n;i++) {
			SSTRING *mod = s_mods.getitem(i);
			dia.newf_str ("",*mod);
		}
		MENU_STATUS code = dia.edit (
			MSG_U(T_APAMOD,"Apache Modules Configuration")
			,MSG_U(I_APAMOD,"You can configure modules that will be loaded by Apache")
			,help_mod
			,nof,MENUBUT_CANCEL|MENUBUT_ADD|MENUBUT_ACCEPT);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			write();
			break;
		}else if(code == MENU_ADD) {
			SSTRING *cs = new SSTRING;
			s_mods.add(cs);
		}

	}
	if (ret == -1) dia.restore();
	return ret;
}

PUBLIC void HTTPD_FEATURES::setdia (DIALOG &dia)
{
	dia.newf_title (MSG_U(T_FEATURES,"Features"),1,"",MSG_R(T_FEATURES));
	dia.newf_chk   ("",includes,MSG_U(I_INCLUDES,"Server side includes"));
	dia.newf_chk   ("",includesnoexec,MSG_U(I_INCLUDESNOEXEC,"IncludesNOEXEC"));
	dia.newf_chk   ("",execcgi,MSG_U(I_EXECCGI,"May execute CGI"));
	dia.newf_chk   ("",indexes,MSG_U(I_INDEXES,"Indexes"));
	dia.newf_chk   ("",followsymlinks,MSG_U(I_FOLLOWSYMLINK,"May follow symlinks"));
	dia.newf_chk   ("",symlinksifownermatch,MSG_U(I_FOLLOWOWNERSYMLINK
		,"Follow symlink if owner matches"));
	dia.newf_chk   ("",multiviews,MSG_U(I_MULTIVIEWS,"Multi views"));
}

// Set the dialog part which is common to virtualhost and the main domain
void defhost_setdia (
	VIEWEDIT &vedit,
	bool advanced,		// Show advanced features
	bool ismain)		// Is this the main domain or a virtualhost section
{
	vedit.newf_title (MSG_U(T_BASIC,"Basic"),1,"",MSG_R(T_BASIC));
	vedit.newf_str (MSG_U(F_SERVERADMIN,"Administrator email"),K_SERVERADMIN);
	if (ismain){
		vedit.newf_str (MSG_U(F_IP,"Domain IP address"),K_NAMEVIRTUALHOST);
	}
	vedit.newf_str (MSG_U(F_SERVERNAME,"Server name"),K_SERVERNAME);
	vedit.newf_str (MSG_U(F_DOCUMENTROOT,"Document root"),K_DOCUMENTROOT);
	if (advanced){
		vedit.newf_str (MSG_U(F_SCRIPTALIAS,"Script Alias"),K_SCRIPTALIAS);
		vedit.newf_str (MSG_U(F_SETUIDUSER,"CGI SetUID User"),K_SETUIDUSER);
		vedit.newf_str (MSG_U(F_SETUIDGROUP,"CGI SetUID Group"),K_SETUIDGROUP);
	}
	vedit.newf_title (MSG_U(T_LOGS,"Logs"),1,"",MSG_R(T_LOGS));
	vedit.newf_str (MSG_U(F_ERRLOG,"Error log"),K_ERRORLOG);
	vedit.newf_str (MSG_U(F_TRANSFERLOG,"Transfer log"),K_TRANSFERLOG);
	vedit.newf_str (MSG_U(F_AGENTLOG,"Agent log"),K_AGENTLOG);
	vedit.newf_str (MSG_U(F_REFERERLOG,"Referer log"),K_REFERERLOG);
}

void ssl_setdia (VIEWEDIT &vedit, bool opt)
{
	FIELD_COMBO *loglevel, *vercli, *proto;
	if(opt)	vedit.newf_title (MSG_U(T_SSLOPTIONS,"SSL Options"),1,"",MSG_R(T_SSLOPTIONS));
	vedit.newf_str (MSG_U(F_SSLCIPHERSUITE,"Cipher Suite"),K_SSLCIPHERSUITE);
	vedit.newf_str (MSG_U(F_SSLCERTFILE,"Certificate File")
		,K_SSLCERTFILE);
	vedit.newf_str (MSG_U(F_SSLCERTKEYFILE,"Certificate Key File")
		,K_SSLCERTKEYFILE);
	vedit.newf_str (MSG_U(F_SSLCACERTPATH,"Certificate Path")
		,K_SSLCACERTPATH);
	vedit.newf_str (MSG_U(F_SSLCACERTFILE,"CA Certificate File")
		,K_SSLCAFILE);
	vedit.newf_str (MSG_U(F_SSLLOG,"Log"),K_SSLLOG);
	vedit.newf_str (MSG_U(F_SSLOPTIONS,"Options"),K_SSLOPTIONS);
	vedit.newf_num (MSG_U(F_VERIFYDEPTH,"Verify Depth"),K_SSLVERIFYDEPTH);
	vedit.newf_num (MSG_U(F_SESSIONCACHETIMEOUT,"Session Cache Timeout")
		,K_SSLSESSIONCACHETIMEOUT);
	vedit.newf_chk ("",K_SSLENGINE,MSG_U(I_SSLENGINE,"Engine"));
	loglevel =	vedit.newf_combo (MSG_U(F_LOGLEVEL,"Log Level")
		,K_SSLLOGLEVEL);
	loglevelcomb(*loglevel);
	vercli = vedit.newf_combo (MSG_U(F_SSLVERIFYCLIENT,"Verify Client")
		,K_SSLVERIFYCLIENT);
	verifyclientcomb(*vercli);
	proto = vedit.newf_combo (MSG_U(F_SSLPROTOCOL,"SSL Protocol")
		,K_SSLPROTO);
	protocomb(*proto);
}

PUBLIC int HTTPD_CONFIG::editdefaults()
{
	int ret = -1;
	VIEW_MAIN vmain (itemss);
	DIALOG dia;
	VIEWEDIT vedit (vmain,dia);
	defhost_setdia (vedit,true,true);
	dia.newf_title (MSG_U(T_TUNING,"Tuning"),1,"",MSG_R(T_TUNING));
	vedit.newf_num (MSG_U(F_LISTENPORT,"Listen on port"),K_PORT);
	vedit.newf_str (MSG_U(F_PIDFILE,"Pid file"),K_PIDFILE);
	vedit.newf_num (MSG_R(F_TIMEOUT),K_TIMEOUT);
	vedit.newf_chk ("",K_HOSTNAMELOOKUPS,MSG_U(I_HOSTNAMELOOKUPS,"Host name lookups"));
	HTTPD_FEATURES features (vmain);
	features.setdia (dia);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (
			MSG_U(T_APACHEDEF,"Apache defaults")
			,MSG_U(I_APACHEDEF,"You can configure the base setup and\n"
				"some defaults")
			,help_apache
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			features.update("",vmain);
			vedit.update("");
			write();
			break;
		}
	}
	if (ret == -1) dia.restore();
	return ret;
}

int httpd_edit()
{
	int ret = 0;
	static const char *m_def = MSG_U(M_DEFAULT,"Defaults");
	static const char *m_domains = MSG_U(M_DOMAINS,"Virtual domains");
	static const char *m_subdirs = MSG_U(M_SUBDIRS,"Sub-directory specs");
	static const char *m_files = MSG_U(M_FILES,"Files specs");
	static const char *m_filesmatch = MSG_U(M_FILESMATCH,"Files match specs");
	static const char *m_mod = MSG_U(M_MODS,"Modules");
	static const char *m_perf = MSG_U(M_PERF,"Performance");
	static const char *m_ssl = MSG_U(M_SSL,"mod_ssl (HTTP secure)");
	static const char *m_certreq = MSG_U(M_CERTREQ,"a certificate request");
	static const char *m_signreq = MSG_U(M_SIGNREQ,"a certificate request");

	static const char *menuopt[]={
		//"-",	MSG_U(M_CONFIG,"Configuration"),
		"",		m_def,
		"",		m_domains,
		"",		m_subdirs,
		"",		m_files,
		"",		m_filesmatch,
		"",		m_mod,
		"", 	m_perf,
		"",		m_ssl,
		//"-",	MSG_U(F_SECURESERV,"SSL key management"),
		//MSG_U(M_GENCERT,"Generate"),m_certreq,
		//MSG_U(M_SIGN,"Sign"),m_signreq,
		NULL,
	};
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt);
	int choice=0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_APACHE,"Apache administration")
			,MSG_U(I_APACHE,"This menu allows to configure the Apache web server")
			,help_apache
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			HTTPD_CONFIG conf;
			if (key == m_def){
				conf.editdefaults();
			}else if (key == m_domains){
				conf.editvhosts ();
			}else if (key == m_subdirs){
				conf.editdirs();
			}else if (key == m_ssl){
				conf.ssl_edit();
			}else if (key == m_certreq){
				conf.certreq();
			}else if (key == m_signreq){
				conf.signreq();
			}else if (key == m_files){
				conf.editfiles(false);
			}else if (key == m_filesmatch){
				conf.editfiles(true);
			}else if (key == m_mod){
				conf.modedit();
			}else if (key == m_perf){
				conf.perfedit();
			}
		}
	}	
	return ret;
}
