
/* - manages main window (group selector) */
/* - manages config-section (for a selected group) */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "amandaconf.h"
#include "amandaconf.m"

#include "am_tools.h"
#include "am_general.cc"
#include "am_holdingdisks.cc"
#include "am_dumptypes.cc"
#include "am_tapetypes.cc"
#include "am_interfaces.cc"
#include "am_disklist.cc"

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

/* select which config-section to edit of a selected config-group */
void select_group_section(const char *given_groupname)
{
    MENU_STATUS my_button=MENU_STATUS(0);
    int    my_selection=0;
    DIALOG_MENU dia_mymenu;
    char my_title[HUGE_STRING_SIZE];

    SSTRING config_dirname;
    SSTRING amandaconf_fullpath;
    t_parser_control *parser_control; // parser control

    config_dirname.setfromf("%s/%s", AMANDA_CONFIG_DIRECTORY, given_groupname);
    amandaconf_fullpath.setfromf("%s/amanda.conf", config_dirname.get());
    CONFIG_FILE cf_amandaconf(amandaconf_fullpath.get(), help_nil, CONFIGF_MANAGED);

    /* init parser_control */
    parser_control=init_parser(cf_amandaconf, ' ', '"');
    add_grouping_rule(parser_control, "holdingdisk ", "}");
    add_grouping_rule(parser_control, "define dumptype ", "}");
    add_grouping_rule(parser_control, "define tapetype ", "}");
    add_grouping_rule(parser_control, "define interface ", "}");


    sprintf(my_title, MSG_U(T_SELECTCONFIGFOR,"Select configuration for %s"), given_groupname);

    dia_mymenu.new_menuitem("", MSG_U(M_GENERAL,"General"));
    dia_mymenu.new_menuitem("", MSG_U(M_DISKLIST,"Disk list"));
    dia_mymenu.new_menuitem("", MSG_U(M_HOLDINGDISKS,"Holding disks"));
    dia_mymenu.newf_title("", MSG_U(T_SECTIONSBAR,"Sections"));
    dia_mymenu.new_menuitem("", MSG_U(M_DUMPTYPES,"Dump types"));
    dia_mymenu.new_menuitem("", MSG_U(M_TAPETYPES,"Tape types"));
    dia_mymenu.new_menuitem("", MSG_U(M_INTERFACES,"Interfaces"));

    while(1){
        my_button=dia_mymenu.editmenu(my_title, MSG_U(I_SELECTCONFIGFOR,"Several items in these configurations have\na very own data style.\nRead the corresponding help text to know\nhow to configure these items properly."), config_menu_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_DEL);
        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            close_parser(parser_control);
            return;
        case MENU_DEL:
            {
                SSTRING my_title;
                my_title.setfromf(MSG_U(T_SGROUPREMOVAL,"Settings group \"%s\" removal"), given_groupname);
                if(confirm_yesno_window(my_title.get(), MSG_U(I_SGROUPREMOVAL,"After deletion this configuration group\ncan't be recovered.\nDo you really want to remove these settings?"))){
                    SSTRING directory_fullpath;
                    directory_fullpath.setfromf("%s/%s", AMANDA_CONFIG_DIRECTORY, given_groupname);
                    if(zaapboom_directory(directory_fullpath.get())){
                        SSTRING my_errortxt;
                        my_errortxt.setfromf(MSG_U(I_ERRORREMOVINGDIR,"Error while removing the following directory:\n%s"), directory_fullpath.get());
                        informational_window(MSG_U(T_ERRORREMOVINGDIR,"Removal error"), my_errortxt.get());
                    }
                    return;
                }
            }
            break;
        default:
            switch(my_selection){
            case 0:
                manage_general_opts_window(given_groupname, cf_amandaconf, parser_control);
                break;
            case 2:
                select_holdingdisks_window(given_groupname, cf_amandaconf, parser_control);
                break;
            case 4:
                select_dumptypes_window(given_groupname, cf_amandaconf, parser_control);
                break;
            case 5:
                select_tapetypes_window(given_groupname, cf_amandaconf, parser_control);
                break;
            case 6:
                select_interfaces_window(given_groupname, cf_amandaconf, parser_control);
                break;
            case 1:
                select_disks_window(given_groupname, cf_amandaconf, parser_control);
                break;
            }
            break;
        }

    }
}

/* load list of directories inside /etc/amanda */
/* adds SSTRINGs to a given SSTRINGS and sorts it (previous entries are kept) */
void load_amanda_configlist(SSTRINGS &my_configlist)
{
    DIR *my_dir;
    struct dirent *ent;

    if((my_dir=opendir(AMANDA_CONFIG_DIRECTORY))){
        while((ent=readdir(my_dir))){
            if(strcmp(ent->d_name, ".")&&strcmp(ent->d_name, "..")){
                SSTRING *my_sstring=new SSTRING;
                my_sstring->setfrom(ent->d_name);
                my_configlist.add(my_sstring);
            }
        }
        closedir(my_dir);
    }
    my_configlist.sort();
}

void add_directory_entry(void)
{
    DIALOG      my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    SSTRING     name_for_new_directory;
    SSTRING     directory_fullpath;
    int         go_for_it=1;
    int         mkdir_errorcode;

    my_dialog.newf_str(MSG_U(F_NAMEFORNEWDIR,"Name for new entry:"), name_for_new_directory);

    while(go_for_it){
        my_button=my_dialog.edit(MSG_U(T_NEWDIR,"New entry"), "", help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT);
        if(my_button==MENU_ACCEPT){
            int cant_create_dir=0;

            if(invalid_chars_present(name_for_new_directory.get())){
                informational_window(MSG_U(T_BADNAMEPROVIDED,"Bad name provided"), MSG_U(I_SPACESNOTALLOWED,"The name can't have space characters."));
                cant_create_dir=1;
            }
            if(!(*(name_for_new_directory.get()))){
                informational_window(MSG_R(T_BADNAMEPROVIDED), MSG_U(I_EMPTYNESSNOTALLOWED,"Empty names are not valid."));
                cant_create_dir=1;
            }

            if(!cant_create_dir){
                directory_fullpath.setfromf("%s/%s", AMANDA_CONFIG_DIRECTORY, name_for_new_directory.get());
                if((mkdir_errorcode=mkdir(directory_fullpath.get(), 0))){
                    SSTRING md_error_txt;

                    switch(errno){
                    case EEXIST:
                        md_error_txt.setfromf(MSG_U(I_DIRNAMETAKEN,"The name you selected is already taken,\nit reflects the following path:\n%s"), directory_fullpath.get());
                        informational_window(MSG_U(T_UNABLE2CREATEENTRY,"Unable to create entry"), md_error_txt.get());
                        break;
                    case ENOENT:
                        md_error_txt.setfromf(MSG_U(I_DIRDOESNTEXIST,"The following directory does not exist:\n%s\nIt is required for creating new entries."), AMANDA_CONFIG_DIRECTORY);
                        informational_window(MSG_R(T_UNABLE2CREATEENTRY), md_error_txt.get());
                        break;
                    default:
                        md_error_txt.setfromf(MSG_U(I_ERRORWHILEMKDIR,"An error occured (code: %d)\nwhile creating the following needed directory:\n%s"), errno, directory_fullpath.get());
                        informational_window(MSG_R(T_UNABLE2CREATEENTRY), md_error_txt.get());
                        break;
                    }
                }else{  // no error occured while creating dir
                    return;
                }
            }
        }else{   // user canceled window
            return;
        }
    }
}

void manage_groups_window(void)
{
    DIALOG_RECORDS dia_groups;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    dia_groups.newf_head("", MSG_U(T_DIRLISTHEAD,"configurations"));

    while(1){
//        MENU_STATUS my_button=(MENU_STATUS)0;
//        int         my_selection=0;
        SSTRINGS    my_configlist;
        int linecounter=0;

        load_amanda_configlist(my_configlist);

//        dia_groups.remove_all(); // cleans window
//        dia_groups.newf_head("", MSG_U(T_DIRLISTHEAD,"configurations"));
        {
            int total_items, my_count=0;
            total_items=my_configlist.getnb();
            while(total_items--){
//                dia_groups.new_menuitem((my_configlist.getitem(my_count++))->get(), "");
                dia_groups.set_menuitem(linecounter++, (my_configlist.getitem(my_count++))->get(), "");
            }
        }

        // remove entries below (they're the previous ones and useless now)
        dia_groups.remove_last(linecounter+1);

        my_button=dia_groups.editmenu(MSG_U(T_DIRLIST,"Amanda configurator"), MSG_U(I_DIRLIST,"Here are listed the defined configurations\ngroups for Amanda.\nEach item represents a physical directory.\n"), help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
                add_directory_entry();
            break;
        default:
            {
                select_group_section((my_configlist.getitem(my_selection))->get());
                break;
            }
        }
    }
}

void start_things(void)
{
    manage_groups_window();
}

