
/* holding disks */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "amandaconf.h"
#include "amandaconf.m"

#include "am_tools.h"
#include "lame_parser.h"

void edit_specified_holdingdisk(t_parser_control *parser_control, const char *holdingdisk_name)
{
    struct {
        SSTRING comment,
            directory;
        complexint use,
            chunksize;
    } my_intvars;

    const char *groupname;
    SSTRING sgroupname;
    SSTRING dialog_title;
    DIALOG my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    sgroupname.setfromf("holdingdisk %s {", holdingdisk_name);
    groupname=sgroupname.get();

    /* loads vars.. */
    bload_str(comment,"comment");
    bload_str(directory,"directory");
    bload_cint(use,"use");
    bload_cint(chunksize,"chunksize");

    /* builds gui.. */
    bgui_str(comment,MSG_R(F_COMMENT));
    bgui_str(directory,MSG_U(F_DIRECTORY,"Directory:"));
    bgui_cint(use,MSG_U(F_SPACETOUSE,"Space to use:"));
    bgui_cint(chunksize,MSG_U(F_CHUNKSIZE,"Chunk size:"));

    /* opens dialog.. */
    dialog_title.setfromf(MSG_U(T_HOLDINGDISKSETTINGS,"Settings for holding disk %s"), holdingdisk_name);
    my_selection=0;
    my_button=my_dialog.editmenu(dialog_title.get(), "", holdingdisks_prop_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ACCEPT:
        /* save vars if requested so.. */
        bsave_str(comment,"comment");
        bsave_str(directory,"directory");
        bsave_cint(use,"use");
        bsave_cint(chunksize,"chunksize");

        update_file(parser_control);
        break;
    case MENU_DEL:
        remove_group(parser_control, groupname);
        update_file(parser_control);
        break;
    default:
        break;
    }
}

void select_holdingdisks_window(const char *given_groupname, CONFIG_FILE &cf_amandaconf, t_parser_control *parser_control)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    my_dialog.newf_head("", MSG_U(T_HOLDINGDISKSLISTHEAD,"holdingdisks"));

    while(1){
        SSTRINGS list_of_groups;
//        MENU_STATUS my_button=(MENU_STATUS)0;
//        int         my_selection=0;
        int linecounter=0;

//        my_dialog.remove_all(); // cleans window
//        my_dialog.newf_head("", MSG_U(T_HOLDINGDISKSLISTHEAD,"holdingdisks"));

        fills_sstrings_with_selected_groups(parser_control, list_of_groups, "holdingdisk ");
        dump_sstrings_to_list(my_dialog, list_of_groups, linecounter);

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(linecounter+1);

        my_button=my_dialog.editmenu(MSG_U(T_HOLDINGDISKSLIST,"Holding disks"), "", holdingdisks_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            ask_name_add_group_entry(parser_control, list_of_groups,
                                     "holdingdisk %s {",
                                     MSG_U(T_ADDINGHOLDINGDISK,"Adding a new holding disk..."),
                                     "", MSG_U(F_NAMEFORNEWHOLDINGDISK,"Name for the new holding disk:"));
            break;
        default:
            {
                edit_specified_holdingdisk(parser_control, list_of_groups.getitem(my_selection)->get());
                break;
            }
        }
    }
}


