
#include <parser.h>
#include <misc.h>
#include <map>
#include <string>
#include "devicelist.h"

DEVICE::DEVICE()
{
	name = NULL;
	descr = NULL;
}

DEVICE::~DEVICE()
{
	free(name);
	free(descr);
}

const char *DEVICE::get_option(const char *name)
{
	map<string,string>::iterator i = options.find(name);
	if (i != options.end())
		return i->second.c_str();
	return NULL;
}

void DEVICELIST::parse_device(xmlNodePtr cur)
{
	DEVICE *dev = new DEVICE();
	dev->name = (char *)xmlGetProp(cur,(unsigned char *)"NAME");
#ifdef DEBUG
	printf("Adding '%s'.\n", dev->name);
#endif
	cur = cur->xmlChildrenNode;
	while (cur != NULL) {
		if (strcmp((char *)cur->name,"DESCRIPTION") == 0) {
			xmlChar *cur_lang = xmlGetProp(cur,(unsigned char *)"LANG");
			if ((cur_lang != NULL && strcmp((char *)cur_lang,lang) == 0)
			    || (cur_lang == NULL && dev->descr == NULL)) {
				free(dev->descr);
				dev->descr = (char *)xmlNodeGetContent(cur);
#ifdef DEBUG
				printf("\tDescription '%s'.\n", dev->descr);
#endif
			}
			free(cur_lang);
		} else if (strcmp((char *)cur->name,"OPTION") == 0) {
			xmlChar *cur_name = xmlGetProp(cur,(unsigned char *)"NAME");
			xmlChar *cur_content = xmlNodeGetContent(cur);
			dev->options[(char *)cur_name] = (char *)cur_content;
#ifdef DEBUG
			printf("\tOption '%s=%s'.\n", cur_name, cur_content);
#endif
			free(cur_name);
			free(cur_content);
		}
		cur = cur->next;
	}
	this->add(dev);
}

void DEVICELIST::parse_devicelist(xmlNodePtr cur)
{
	while (cur != NULL) {
		if (strcmp((char *)cur->name,"COMMENT") != 0){
			xmlChar *cur_arch = xmlGetProp(cur,(unsigned char *)"ARCH");
			if (cur_arch == NULL || strcmp((char *)cur_arch,arch) == 0) {
				parse_device(cur);
			}
			free (cur_arch);
		}
		cur = cur->next;
	}
}

DEVICELIST::DEVICELIST(const char *filename, const char *type)
{
	xmlDocPtr doc = xmlParseFile(filename);
	xmlNodePtr cur;
	xmlChar *cur_type;
	
	/* Must change it later */
	arch = "i386";
	lang = linuxconf_getlang();

	if (doc == NULL) return;
	
	cur = xmlDocGetRootElement(doc);
	if (cur == NULL) return;
	
	if (strcmp((char *)cur->name, "DEVICELIST") != 0) return;
	
	cur_type = xmlGetProp(cur,(unsigned char *)"TYPE");
	if (strcmp((char *)cur_type,type) != 0) return;
	free(cur_type);
	
	parse_devicelist(cur->xmlChildrenNode);
	xmlFreeDoc(doc);
}

DEVICE *DEVICELIST::getitem(int no) const
{
	return (DEVICE *) ARRAY::getitem(no);
}

DEVICE *DEVICELIST::getitem_by_name(const char *name)
{
	int nb = getnb();
	for (int i = 0; i != nb; i++) {
		DEVICE *dev = getitem(i);
		if (strcmp(dev->name,name) == 0)
			return dev;
	}
	return NULL;
}

DEVICE *DEVICELIST::getitem_by_descr(const char *descr)
{
	int nb = getnb();
	for (int i = 0; i != nb; i++) {
		DEVICE *dev = getitem(i);
		if (strcmp(dev->descr,descr) == 0)
			return dev;
	}
	return NULL;
}

DEVICE *DEVICELIST::getitem_by_opt(const char *opttype, const char *whichone)
{
	int nb = getnb();
	for (int i = 0; i != nb; i++) {
		DEVICE *dev = getitem(i);
		const char   *theoption;
		
		if((theoption=dev->get_option(opttype))){
			if(!strcmp(theoption, whichone))
				return dev;
		}                           
	}
	return NULL;
}

#ifdef DEBUG

int main()
{
	DEVICELIST devlist("mouse.list","mouse");
	int nb = devlist.getnb();
	for (int i = 0; i < nb; i++) {
		DEVICE *dev = devlist.getitem(i);
		printf("%d: Found '%s'.\n",i,dev->name);
	}
	return 0;
}

#endif /* DEBUG */
