#ifndef guruengine_h
#define guruengine_h
#pragma interface
#ifndef MISC_H
    #include <misc.h>
#endif

#ifndef MODULE_H
	#include <module.h>
#endif

#include <modapi_def.h>
#include <modapi.h>    


#define _TLMP_gurupath

enum GURUPATH_MODE {
	GURUPATH_EVAL,		// Evaluate the various node of the tree
						// to know their status
	GURUPATH_EDIT,		// Edit the nodes
};

#define MAXGURUPATH		6		// _F_gurupath::path3. Modify is more paths
								// are needed.
class GURUPATH_STATUS_PRIVATE;

class GURUPATH_STATUS {
public:
	GURUPATH_STATUS_PRIVATE *priv;
	SSTRING title;		// Short title of the node
	SSTRING status;		// Some explanation about potential problem
						// or important information
						// with this node configuration
	bool wearehere;		// This is the node under edition now
	bool is_possible;	// This path is possible, prior condition are met
	bool is_filled;		// The user has supplied valid input
						// so this path is either completed or we
						// can pass to other path
	bool nodemissing;	// Used internally to tell does not exist
	bool some_errors;	// There are some problems with the configuration
						// of this node
	int level;			// top level is 0, each step to the right is + 1
	int nbpath;			// Number of sub-option
	GURUPATH_STATUS *tb[MAXGURUPATH];
					// Status of the sub-options, maximum
	int buttonid;		// ID of the button for this node in the map
	bool button_created;	// The button has been defined to the front-end
	int x,y;			// Coordinate of the button/circle
	struct {
		SSTRING shorttext;
		SSTRING longtext;
	} terminal;
	/*~PROTOBEG~ GURUPATH_STATUS */
public:
	GURUPATH_STATUS (GURUPATH_STATUS_PRIVATE *_priv);
	~GURUPATH_STATUS (void);
	/*~PROTOEND~ GURUPATH_STATUS */
};

struct _F_gurupath{
	class gurupath_private *priv;
	void settitle (const char *title);
	void setintro (const char *longtext);
	void attention ();
	void seticon (const char *icon);
	void setterminal (const char *shortext, const char *longtext);
	bool edit (HELP_FILE &);
	bool edit ();
	void setbutinfo (int id, const char *title, const char *icon);
	void setcursor (int nof);
	#define _F_gurupath_dialog(nom) void nom dialog(DIALOG &dia)
	virtual _F_gurupath_dialog( )=0;
	#define _F_gurupath_eval(nom) void nom eval(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurupath_eval( )=0;
	#define _F_gurupath_dobutton(nom) void nom dobutton(int id)
	virtual _F_gurupath_dobutton( );
	#define _F_gurupath_path1(nom) void nom path1(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurupath_path1( );
	#define _F_gurupath_path2(nom) void nom path2(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurupath_path2( );
	#define _F_gurupath_path3(nom) void nom path3(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurupath_path3( );
	#define _F_gurupath_path4(nom) void nom path4(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurupath_path4( );
	#define _F_gurupath_path5(nom) void nom path5(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurupath_path5( );
	#define _F_gurupath_path6(nom) void nom path6(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurupath_path6( );
};

#define _TLMP_gurusteps

struct _F_gurusteps{
	class gurusteps_private *priv;
	void settitle (const char *title);
	void setintro (const char *longtext);
	void attention ();
	void seticon (const char *icon);
	void setterminal (const char *shortext, const char *longtext);
	bool edit (HELP_FILE &);
	bool edit ();
	void setcursor (int nof);
	#define _F_gurusteps_eval1(nom) void nom eval1(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_eval1( )=0;
	#define _F_gurusteps_dialog1(nom) void nom dialog1(DIALOG &dia)
	virtual _F_gurusteps_dialog1( )=0;
	#define _F_gurusteps_eval2(nom) void nom eval2(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_eval2( );
	#define _F_gurusteps_dialog2(nom) void nom dialog2(DIALOG &dia)
	virtual _F_gurusteps_dialog2( );
	#define _F_gurusteps_eval3(nom) void nom eval3(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_eval3( );
	#define _F_gurusteps_dialog3(nom) void nom dialog3(DIALOG &dia)
	virtual _F_gurusteps_dialog3( );
	#define _F_gurusteps_eval4(nom) void nom eval4(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_eval4( );
	#define _F_gurusteps_dialog4(nom) void nom dialog4(DIALOG &dia)
	virtual _F_gurusteps_dialog4( );
	#define _F_gurusteps_eval5(nom) void nom eval5(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_eval5( );
	#define _F_gurusteps_dialog5(nom) void nom dialog5(DIALOG &dia)
	virtual _F_gurusteps_dialog5( );
	#define _F_gurusteps_eval6(nom) void nom eval6(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_eval6( );
	#define _F_gurusteps_dialog6(nom) void nom dialog6(DIALOG &dia)
	virtual _F_gurusteps_dialog6( );
	#define _F_gurusteps_path1(nom) void nom path1(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_path1( );
	#define _F_gurusteps_path2(nom) void nom path2(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_path2( );
	#define _F_gurusteps_path3(nom) void nom path3(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_path3( );
	#define _F_gurusteps_path4(nom) void nom path4(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_path4( );
	#define _F_gurusteps_path5(nom) void nom path5(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_path5( );
	#define _F_gurusteps_path6(nom) void nom path6(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurusteps_path6( );
};

#define _TLMP_guruiter

struct _F_guruiter{
	class guruiter_private *priv;
	void settitle (const char *title);
	void setintro (const char *longtext);
	void attention ();
	void seticon (const char *icon);
	void setterminal (const char *shortext, const char *longtext);
	bool edit (HELP_FILE &);
	bool edit ();
	void setcursor (int nof);
	#define _F_guruiter_eval(nom) void nom eval(int step,GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_guruiter_eval( )=0;
	#define _F_guruiter_dialog(nom) void nom dialog(int step,DIALOG &dia)
	virtual _F_guruiter_dialog( )=0;
	#define _F_guruiter_path1(nom) void nom path1(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_guruiter_path1( );
	#define _F_guruiter_path2(nom) void nom path2(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_guruiter_path2( );
	#define _F_guruiter_path3(nom) void nom path3(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_guruiter_path3( );
	#define _F_guruiter_path4(nom) void nom path4(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_guruiter_path4( );
	#define _F_guruiter_path5(nom) void nom path5(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_guruiter_path5( );
	#define _F_guruiter_path6(nom) void nom path6(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_guruiter_path6( );
};


#define _TLMP_gurumanage

struct _F_gurumanage{
	#define _F_gurumanage_exec(nom) void nom exec(GURUPATH_MODE mode, GURUPATH_STATUS &status)
	virtual _F_gurumanage_exec( )=0;
};

#include "guruengine.p"

#endif
