#include <string.h>
#include <dialog.h>
#include <fstab.h>
#include <netconf.h>
#include "filesystem.h"
#include "filesystem.m"

static HELP_FILE help_mount ("filesystem","mount");
/*
	Check if a given directory exist.
	If it does not exist, try to find out if it is part of an
	unmounted file system. If this is the case, let the user mount it.

	Return true if the directory is available

	mpoint will contain the mount points if a mount was done.
	mngrpm_unmountif() must be called by the client to do the unmount
	if needed.
*/
bool filesystem_ismounted (const char *path, SSTRING &mpoint, const char *cdtitle)
{
	bool ret = true;
	FSTAB fstab;
	int lenpath = strlen (path);
	FSTAB_ENTRY *found = NULL;
	for (int i=0; i<fstab.getnb(); i++){
		FSTAB_ENTRY *ent = fstab.getitem(i);
		if (ent->is_valid()){
			const char *mpt = ent->getmpoint();
			int len = strlen(mpt);
			if (strcmp(path,mpt)==0){
				// Exact match
				found = ent;
				break;
			}else if (lenpath > len
				&& strncmp(path,mpt,len)==0
				&& path[len] == '/'){
				found = ent;
				break;
			}
		}
	}
	if (found != NULL && !found->is_mounted()){
		SSTRING buf;
		if (cdtitle != NULL && cdtitle[0] != '\0'){
			buf.setfromf (MSG_U(I_INSERTCD
				,"Please insert CDROM\n\n\t%s"),cdtitle);
		}else{
			buf.setfromf (MSG_U(I_MOUNT
					,"The directory %s\n"
					"is part of an unmounted filesystem\n"
					"Do you want to mount it ?"),path);
			if (strcmp(found->getfs(),"iso9660")==0){
				buf.append (MSG_U(I_PUTCD,"\n(Do not forget to put the CDrom in)"));
			}
		}
		if (dialog_yesno (MSG_U(Q_MOUNT,"Mounting file system")
			,buf.get(),help_mount)==MENU_YES
			&& perm_rootaccess(MSG_U(P_MOUNT,"mount file systems"))){
			ret = found->domount() != -1;
			if (ret) mpoint.setfrom (found->getmpoint());
		}
	}
	if (ret){
		int type = file_type (path,true); /* Follow symlinks. */
		if (type == -1){
			xconf_error (MSG_U(E_MISSING,"%s does not exist"),path);
			ret = false;
		}else if (type != 1){
			xconf_error (MSG_U(E_NOTDIR,"%s exists but is not a directory"),path);
			ret = false;
		}
	}
	return ret;
}
/*
	Unmount what was mounted by mngrpm_ismounted()
*/
void filesystem_unmountif (SSTRING &mpoint)
{
	if (!mpoint.is_empty()) netconf_system_if ("umount",mpoint.get());
}

