#pragma implementation
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include "fstab.h"
#include <userconf.h>
#include <netconf.h>
#include "fstab.m"
#include <dialog.h>

static FSTAB_HELP_FILE help_access ("access");

void fstab_edit()
{
	int choice=0;
	static const char *local_partition = MSG_U(M_LOCALD,"Access local drive");
	static const char *remote_nfs = MSG_U(M_NFSVOL,"Access nfs volume");
	static const char *samba_fs   = MSG_U(M_SAMBA,"Access samba volume (WfWg)");
	static const char *swap_volume = MSG_U(M_SWAP,"Configure swap files and partitions");
	static const char *fixperm = MSG_U(M_FIXPERM,"Check some file permissions");
	static const char *quota = MSG_U(M_QUOTA,"Set quota defaults");
	static const char *menuopt[]={
		"",		local_partition,
		"",		remote_nfs,
		#if 0
		"",		samba_fs,
		#endif
		"",		swap_volume,
		"",		quota,
		"",		fixperm,
		NULL
	};
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt);
	module_setmenu (dia,MENU_FSCONF);
	while (1){
		MENU_STATUS code = dia.editmenu (
			MSG_U(T_FSCONF,"Filesystem configurator")
			,MSG_U(I_FSCONF,"This package allows you to configure\n"
			 "which partitions and network volumes your workstation\n"
			 "can access")
			,help_access
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = dia.getmenustr(choice);
			if (key == local_partition){
				fstab_edit (FSTAB_ENTRY_LOCAL);
			}else if (key == remote_nfs){
				fstab_edit (FSTAB_ENTRY_NFS);
			}else if (key == samba_fs){
				xconf_notice (MSG_U(N_NOSAMBA
					,"Samba management not available\n"
					"at this time"));
			}else if (key == swap_volume){
				fstab_edit (FSTAB_ENTRY_SWAP);
			}else if (key == quota){
				quota_editdef ();
			}else if (key == fixperm){
				if (dialog_mode != DIALOG_TREE
					&& perm_rootaccess (
					MSG_U(P_FIXPERM,"To fix file permission"))){
					simul_init();
					fixperm_check();
					int ok = simul_prompt(false);
					if (ok == 1){
						net_setshowmode (0);
						fixperm_check();
						net_setshowmode (1);
					}else if (ok == 0){
						xconf_notice (MSG_U(N_ALLISOK,"All is ok"));
					}
				}
			}else{
				module_domenu (MENU_FSCONF,key);
			}
		}
	}
}

int fstab_main(int argc, char *argv[])
{
	if (perm_rootaccess(MSG_U(P_MNGFS,"To manage file systems"))){
		if (argc == 1){
			fstab_edit();
		}else if (argc == 2 && strcmp(argv[1],"--check")==0){
			fstab_check();
		}else if (argc == 2 && strcmp(argv[1],"--updatequota")==0){
			quota_applyall();
		}else if (argc >= 3 && strcmp(argv[1],"--setuquota")==0){
			quota_setquota(false,argv[2],argc-3,argv+3);
		}else if (argc >= 3 && strcmp(argv[1],"--setgquota")==0){
			quota_setquota(true,argv[2],argc-3,argv+3);
		}else{
			xconf_error (
				MSG_U(E_FSTABARG
					,"fsconf command line arguments\n"
					 "\n"
					 "    --check\n"
					 "    --setuquota user --device device [ options ]\n"
					 "    --setgquota group --device device [ options ]\n"
					 "    --updatequota\n"
					 "    --help\n"
					 "\n")
				);
		}
	}
	return 0;
}

const char *fsconf_getusage()
{
	return MSG_R(E_FSTABARG);
}

