#include "diawxxt.h"

PUBLIC GROUP::GROUP (MFORM *_parent, const char *_id, const char *_title)
	: MFORM (_parent,_id)
{
	int len = strlen(_title);
	marge_droite = marge_gauche = 10;
	marge_haut = marge_bas = 14;
	if (len == 0){
		title = NULL;
	}else{
		title = strdup(_title);
		min_width = len*14;
		marge_haut = 16;
	}
}
PUBLIC GROUP::GROUP (MFORM *_parent, const char *_id)
	: MFORM (_parent,_id)
{
	title = NULL;
	marge_droite = marge_gauche = 14;
	marge_haut = marge_bas = 14;
	min_width = 14;
}

PUBLIC GROUP::~GROUP()
{
	free ((char*)title);
}

/*
	Draw the edge of the GROUP
*/

PUBLIC void GROUP::drawgroup()
{
	//g.setFont(new Font("Helvetica", Font.PLAIN, 14));

	//FontMetrics met = g.getFontMetrics();
	int iCharHei = (int)GetCharHeight();

 	int iCharLen = 0;
	if (title != NULL){
		float fw,fh;
		dc->GetTextExtent(title,&fw,&fh);
		iCharLen = (int)fw;
	}

	int g_width,g_height;
	GetSize (&g_width,&g_height);

	//g.setColor (black);
	//g.drawRect(1,1,g_width-2,g_height-2);

	int offx = 3;
	int offy = iCharHei/2;

	int xpos = 0;
	int ypos = 0;

	int startx = xpos + offx;
	int starty = ypos + offy;
	int endx =  g_width - 2 * offx - 1;
	int endy =  g_height - 2 * offy + 1;

	// Rectangle de base autour du groupe avec effet 3D
	// Boite effect ombre

	dc->SetPen (pen_dark);
	int endy_gray = starty + endy - 2;
	int endx_gray = startx + endx - 2;
	dc->DrawLine (startx,starty,startx,endy_gray);
	dc->DrawLine (startx,starty,endx_gray,starty);

	dc->DrawLine (startx,endy_gray,endx_gray,endy_gray);
	dc->DrawLine (endx_gray,starty,endx_gray,endy_gray);


	// Boite effect lumiere
	dc->SetPen (pen_light);
	dc->DrawLine (startx+1,starty+1,startx+1,endy_gray-1);
	dc->DrawLine (startx+1,starty+1,endx_gray-1,starty+1);

	dc->DrawLine (startx,endy_gray+1,endx_gray+1,endy_gray+1);
	dc->DrawLine (endx_gray+1,starty,endx_gray+1,endy_gray+1);

	if (title != NULL){
		// Affiche le title du groupe en effacant l'arriere
		dc->SetBrush (brush_back);
		dc->SetPen   (pen_back);
		dc->DrawRectangle(startx+offx*2-2,starty-offy/2,iCharLen+4,iCharHei);

		dc->SetPen (pen_black);
		dc->DrawText (title,startx+offx*2,starty-offy);
	}
}
PUBLIC void GROUP::OnPaint()
{
	MFORM::OnPaint();
	drawgroup();
}


