#include "diawxxt.h"

PUBLIC COMBO_LIST::COMBO_LIST (COMBO *_cm, int x, int y)
	: MAINFORM (_cm->getframe(),"",x,y,wxTRANSIENT)
{
	cm = _cm;
}

PUBLIC void COMBO_LIST::OnEvent(wxMouseEvent & event)
{
	int it = locate_butfill (event);
	if (it != -1){
		int sel = atoi(tbc[it]->id);
		cm->select (sel);
		dispose();
		cm->mf = NULL;
	}
}


PUBLIC COMBO_ITEM::COMBO_ITEM(const char *_val1, const char *_val2)
{
	val1 = strdup(_val1);
	val2 = strdup(_val2);
	next = NULL;
}

PUBLIC COMBO_ITEM::~COMBO_ITEM()
{
	free ((char*)val1);
	free ((char*)val2);
}

PUBLIC void COMBO_ITEM::set (const char *_val1, const char *_val2)
{
	free ((char*)val1);
	free ((char*)val2);
	val1 = strdup(_val1);
	val2 = strdup(_val2);
}

static void button_func (wxObject &o, wxCommandEvent &)
{
	wxButton *b = (wxButton*)&o;
	COMBO *p = (COMBO*)b->GetParent();
	p->showlist();
}


PUBLIC COMBO::COMBO (
	MFORM *_parent,
	const char *initval,
	int cols,			// Sise of the edit field or -1 for listonly
	bool listonly)		// Only member of the help list allowed
	: MFORM (_parent,"")
{
	if (listonly){
		text = NULL;
		if (strlen(initval) < 10){
			// To small field are ugly
			char tmp[100];
			sprintf (tmp,"%-*.*s",10,10,initval);
			New_buttonfill ("",tmp,0,NULL);
		}else{
			New_buttonfill ("",initval,0,NULL);
		}
	}else{
		text = New_string (cols,initval);
	}
	MFORM_C *m = alloc_mf();
	wxButton *ret = new wxButton(this,button_func," ",-1,-1,-1,3*(int)GetCharHeight()/2);
	m->c = ret;
	m->type = T_BUTTON;

	mf = NULL;
	last = first = NULL;
	nbitem = 0;
	pickverbose = false;
}

PUBLIC COMBO::~COMBO()
{
	if (mf != NULL) mf->dispose();
}

PUBLIC void COMBO::OnEvent(wxMouseEvent & event)
{
	int it = locate_butfill (event);
	if (it != -1){
		showlist();
	}
}

PRIVATE void COMBO::fixsize(const char *val1)
{
	if (text == NULL){
		// Make sure the button is large enough
		const char *curval = getText();
		int lenval1 = strlen(val1);
		if (lenval1 > (int)strlen(curval)){
			char tmp[lenval1+1];
			sprintf (tmp,"%-*s",lenval1,curval);
			tbc[0]->sets (tmp);
		}
	}
}


PUBLIC void COMBO::addItem (const char *val1, const char *val2)
{
	COMBO_ITEM *item = new COMBO_ITEM (val1,val2);
	if (first == NULL) first = item;
	if (last != NULL) last->next = item;
	last = item;
	nbitem++;
	fixsize(val1);
}

PUBLIC void COMBO::setItem (int no, const char *val1, const char *val2)
{
	if (no >= nbitem){
		addItem (val1,val2);
	}else{
		COMBO_ITEM *pt = first;
		while (no != 0 && pt != NULL){
			pt = pt->next;
			no--;
		}
		if (pt != NULL) pt->set (val1,val2);
		fixsize(val1);
	}
}


PUBLIC void COMBO::showlist()
{
	if (mf != NULL){
		mf->dispose();
		mf = NULL;
	}else{
		//const char *cur = text->GetValue();
		int absx = 0;
		int ww;
		int absy;
		GetSize (&ww,&absy);
		ClientToScreen (&absx,&absy);
		mf = new COMBO_LIST (this,absx,absy);
		int no = 0;
		COMBO_ITEM *item = first;
		pickverbose = true;
		while (item != NULL){
			const char *val1 = item->val1;
			if (strcmp(val1," ")!=0 && val1[0] != '\0') pickverbose = false;
			char tmp[5];
			sprintf (tmp,"%d",no);
			mf->New_buttonfill (tmp,val1,0,NULL);
			mf->New_buttonfill (tmp,item->val2,0,NULL);
			mf->Newline();
			no++;
			item = item->next;
		}
		mf->Popup();
	}
}
PUBLIC const char *COMBO::getText()
{
	return text != NULL ? text->GetValue() : tbc[0]->s;
}
PUBLIC void COMBO::setText(const char *val)
{
	if (text != NULL){
		text->SetValue((char*)val);
	}else{
		tbc[0]->sets (val);
		Clear();
		OnPaint();
	}
}
PUBLIC void COMBO::select (int no)
{
	COMBO_ITEM *item = first;
	while (item != NULL){
		if (no == 0){
			const char *val = pickverbose
				? (char*)item->val2
				: (char*)item->val1;
			if (text != NULL){
				text->SetValue ((char*)val);
			}else{
				tbc[0]->sets (val);
				Clear();
				OnPaint();
			}
			break;
		}
		item = item->next;
		no--;
	}
}


