#include "dialog.h"

/*
	Display a dialog box with two buttons - Yes and No
	Return MENU_YES, MENU_NO or MENU_ESCAPE
*/
EXPORT MENU_STATUS dialog_yesno(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,		/* path of a help text file */
								/* or help_nil */
	bool default_is_yes)
{
	dialog_clear();
	DIALOG dia;
	dia.settype (DIATYPE_POPUP);
	if (!default_is_yes) dia.set_selected_button(1);
	int nof = 0;
	return dia.edit (title,prompt,helpfile,nof,MENUBUT_YES|MENUBUT_NO);
}

/*
	Display a dialog box with two buttons - Yes and No
	Return MENU_YES, MENU_NO or MENU_ESCAPE
*/
EXPORT MENU_STATUS dialog_yesno(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile)		/* path of a help text file */
								/* or help_nil */
{
	return dialog_yesno (title,prompt,helpfile,true);
}


#ifdef TEST

int main (int argc, char *argv[])
{
	MENU_STATUS ret1,ret2;
	init_dialog();
	ret1 = dialog_yesno("This is a test","Are you\nsure you want to exit\n"
		,NULL);
	ret2 = dialog_yesno("This is a test","Are you\nsure you want to exit\n"
		,"/usr/lib/conf/askrunlevel/askrunlevel.help");
	endwin();
	printf ("ret1 = %d ret2 = %d\n",ret1,ret2);
	return 0;
}

#endif

