/*
 * $Id: endians.h,v 1.4 2001/11/09 19:24:23 antona Exp $
 *
 * endians.h - Definitions related to handling of byte ordering. Part of the
 * 	       Linux-NTFS project.
 * 	       
 * Copyright (c) 2000,2001 Anton Altaparmakov.
 *
 * This program/include file is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program/include file is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (in the main directory of the Linux-NTFS 
 * distribution in the file COPYING); if not, write to the Free Software
 * Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* 
 * Notes:
 *
 * 	We define the conversion functions including typecasts since the
 * defaults don't necessarily perform appropriate typecasts.
 * 	Also, using our own functions means that we can change them if it
 * turns out that we do need to use the unaligned access macros on 
 * architectures requirering aligned memory accesses...
 */

#ifndef ENDIANS_H
#define ENDIANS_H

#include <asm/byteorder.h>

#include "types.h"

/* Unsigned from LE to CPU conversion. */

#define le16_to_cpu(x)		(__u16)__le16_to_cpu((__u16)(x))
#define le32_to_cpu(x)		(__u32)__le32_to_cpu((__u32)(x))
#define le64_to_cpu(x)		(__u64)__le64_to_cpu((__u64)(x))

#define le16_to_cpup(x)		(__u16)__le16_to_cpu(*(__u16*)(x))
#define le32_to_cpup(x)		(__u32)__le32_to_cpu(*(__u32*)(x))
#define le64_to_cpup(x)		(__u64)__le64_to_cpu(*(__u64*)(x))

/* Signed from LE to CPU conversion. */

#define sle16_to_cpu(x)		(__s16)__le16_to_cpu((__s16)(x))
#define sle32_to_cpu(x)		(__s32)__le32_to_cpu((__s32)(x))
#define sle64_to_cpu(x)		(__s64)__le64_to_cpu((__s64)(x))

#define sle16_to_cpup(x)	(__s16)__le16_to_cpu(*(__s16*)(x))
#define sle32_to_cpup(x)	(__s32)__le32_to_cpu(*(__s32*)(x))
#define sle64_to_cpup(x)	(__s64)__le64_to_cpu(*(__s64*)(x))

/* Unsigned from CPU to LE conversion. */

#define cpu_to_le16(x)		(__u16)__cpu_to_le16((__u16)(x))
#define cpu_to_le32(x)		(__u32)__cpu_to_le32((__u32)(x))
#define cpu_to_le64(x)		(__u64)__cpu_to_le64((__u64)(x))

#define cpu_to_le16p(x)		(__u16)__cpu_to_le16(*(__u16*)(x))
#define cpu_to_le32p(x)		(__u32)__cpu_to_le32(*(__u32*)(x))
#define cpu_to_le64p(x)		(__u64)__cpu_to_le64(*(__u64*)(x))

/* Signed from CPU to LE conversion. */

#define scpu_to_le16(x)		(__s16)__cpu_to_le16((__s16)(x))
#define scpu_to_le32(x)		(__s32)__cpu_to_le32((__s32)(x))
#define scpu_to_le64(x)		(__s64)__cpu_to_le64((__s64)(x))

#define scpu_to_le16p(x)	(__s16)__cpu_to_le16(*(__s16*)(x))
#define scpu_to_le32p(x)	(__s32)__cpu_to_le32(*(__s32*)(x))
#define scpu_to_le64p(x)	(__s64)__cpu_to_le64(*(__s64*)(x))

/*
 * Constant endianness conversion defines.
 */
#define const_le16_to_cpu(x)	__constant_le16_to_cpu(x)
#define const_le32_to_cpu(x)	__constant_le32_to_cpu(x)
#define const_le64_to_cpu(x)	__constant_le64_to_cpu(x)

#define const_cpu_to_le16(x)	__constant_cpu_to_le16(x)
#define const_cpu_to_le32(x)	__constant_cpu_to_le32(x)
#define const_cpu_to_le64(x)	__constant_cpu_to_le64(x)

#endif /* defined ENDIANS_H */

