/***************************************************************************
                          crxdisplay.cpp  -  description
                             -------------------
    begin                : Sun Sep 17 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "crxdisplay.h"

CRxdisplay::CRxdisplay(QWidget *parent,int channel, const char *name ) : QFrame(parent,name)

{


setFrameStyle(QFrame::WinPanel | QFrame::Sunken);

setFontPropagation(AllChildren);
setFont(settings.RxLabelFont);
QFontMetrics fm(settings.RxLabelFont);
theircall="";
Name="";
	


	Modus = new ModeSelect(this);
	connect(Modus,SIGNAL(ModeChanged(Mode)),this,SLOT(ChangedToMode(Mode)));

// RX Values

  rxtune= new QGroupBox(1,Horizontal,"Rx Freq",this);
  rxtune->setAlignment(AlignCenter);
	rxtune->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
	rxtune->setFixedSize(Modus->width(),fm.height()*3+22);
	rxtune->setMargin(0);
  rxtune->setLineWidth(1);

	
  rxfreq= new QSpinBox(rxtune,"RxFrequency");
  rxfreq->setRange(300,2500);
	rxfrequency=1000;
  rxfreq->setValue(1000);


 // Changing RX- Frequency
  connect(rxfreq,SIGNAL(valueChanged(int)),this,SLOT(changerxfreq(int)));

// AFC
	UseAfc=true;
  bafc= new QRadioButton(rxtune,"afc");
  bafc->setText("AFC(F3)");
  bafc->setChecked(UseAfc);
	connect(bafc,SIGNAL(toggled(bool)),this,SLOT(afc(bool)));
	bafc->setAccel(Key_F3);
	

// TriggerText
	TriggerBox=new QGroupBox(1,Horizontal,"Trigger",this);
	TriggerBox->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
	TriggerBox->setAlignment(AlignCenter);
	TriggerBox->setFixedSize(Modus->width(),3*fm.height()+22);
	TriggerText = new QLineEdit("CQ CQ",TriggerBox);	
	Trigger = new QRadioButton(TriggerBox);
	Trigger->setText(tr("Activate"));
	Trigger->setChecked(false);
// Squelch

	Squelch = new CSquelch(this);

// Title of RxWindow
	title="RxWindow "+title.setNum(channel+1);
  channelNumber=channel;
// Recording
 RecordBox=new QGroupBox(1,Horizontal,"Record Qso",this);
 RecordBox->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
 RecordBox->setAlignment(AlignCenter);
 RecordBox->setFixedSize(fm.width("Record Qso")+20,TriggerBox->height());	
 Debug=new QRadioButton(RecordBox);
 Debug->setText("On/Off");
 Debug->setChecked(false);
 connect(Debug,SIGNAL(clicked()),this,SLOT(switchDebug()));

		

// DisplayWindow
	rxwindow=new CRxwindow(this);
	rxwindow->setReadOnly(TRUE);
	rxwindow->setFont(settings.RxWindowTextFont);
	rxwindow->setMaxLine(50);
	rxwindow->setTrigger(TriggerText->text());
	connect(Trigger,SIGNAL(toggled(bool)),rxwindow,SLOT(setTriggerMode(bool)));
	connect(TriggerText,SIGNAL(returnPressed()),this,SLOT(newTriggerText()));
	connect(this,SIGNAL(TriggerTextChanged(QString)),rxwindow,SLOT(setTrigger(QString)));
	connect(rxwindow,SIGNAL(triggered()),this,SLOT(triggered()));
	
// Now , as each component is defined, the colour is to be set
  setColor(settings.colours[channel]);	


}

CRxdisplay::~CRxdisplay()
{
}

double CRxdisplay::getRxFrequency()
{
return rxfrequency;
}

void CRxdisplay::resizeEvent(QResizeEvent *)
{
int ButtonHeight;

QFontMetrics fm(settings.RxLabelFont);

move(10,0);

ButtonHeight=fm.height()+4;

int xpos,ypos,left;
int elements_height;
int elements_width;


if (width() > 650)
	{
		setLineWidth(4);
		setMargin(15);
	}
else
	{
		setLineWidth(4);
		setMargin(10);
	}			
//Setting FrameSize

left=5;
elements_width=rxtune->width()-2*rxtune->frameWidth()-2;
elements_height=(rxtune->height()-2*rxtune->frameWidth())/3;



//Calculating position of Elements
xpos=rxtune->frameWidth()+1;
ypos=rxtune->frameWidth();


// Position PSKMode Window
	Modus->move(left,height()-5-Modus->height());	

// Position RX- Control Window
	rxtune->move(left,Modus->y()-5-rxtune->height());					


// Trigger

	TriggerBox->move(left,rxtune->y()-5-TriggerBox->height());

		
//Recording
 RecordBox->move(Modus->x()+Modus->width()+left,TriggerBox->y());
//Squelch

Squelch->setGeometry(2*left+Modus->width(),TriggerBox->y()+TriggerBox->height()+5,
										RecordBox->width(),height()-TriggerBox->y()-TriggerBox->height()-10);

// Display window


rxwindow->setGeometry(Squelch->x()+Squelch->width()+10,15,
					width()-Squelch->x()-95,height()-10);

}

bool CRxdisplay::SquelchOn()
{
return Squelch->SquelchOn();
}

void CRxdisplay::setFastSquelch(bool squelch)
{
Squelch->setSquelchStatus(squelch);
}

void CRxdisplay::setSquelchValue(int i)
{
Squelch->setSquelchLevel(i);
}


void CRxdisplay::changerxfreq(int freq)
{
if ((int)rxfrequency != freq)
	{
		rxfrequency=freq;
		rxfreq->setValue( freq);
		emit rxFrequencyChanged(channelNumber,freq);
	}	
}


void CRxdisplay::afc(bool type)
{
UseAfc=type;
emit toggleAfc(UseAfc);
}

void CRxdisplay::showchar(char c) {if (SquelchOn()) rxwindow->updaterx(c);}

void CRxdisplay::setRxFrequency(double freq)
{
if (rxfrequency != freq)
	{
		rxfrequency=freq;
		rxfreq->setValue((int) freq);
		emit rxFrequencyChanged(channelNumber,(int) freq);
	}	
}

/** prepares the new TriggerText and passes it to the Trigger detection */
void CRxdisplay::newTriggerText()
{
///emit TriggerTextChanged(TriggerText->text());
rxwindow->setTrigger(TriggerText->text());
}
/** Signals the TriggerCondition and switches to the appropriate Window */
void CRxdisplay::triggered()
{
emit triggeredWindow(channelNumber);
Trigger->setChecked(false); //Deactivate Trigger
QApplication::beep();
}
/** clears the content of  the dependent RxWIndow */
void CRxdisplay::clearWindow()
{
rxwindow->clearRxWindow();
}
/** enables/disables Debugging for the Rx window */

void CRxdisplay::switchDebug()
{

		QString s;
		QString FileName="Rx_Debug_"+s.setNum(channelNumber);
		rxwindow->setDebugFile(FileName);
}	


/** Changes the color of Text and Labels in  the RXWindow */
void CRxdisplay::setColor(QColor color)
{
QPalette p;
					

		p=rxwindow->palette();	
		p.setColor(QColorGroup::Text,color);
		rxwindow->setPalette(p);
		repaint();
}
/** Draws the widget including title text */
void CRxdisplay::paintEvent(QPaintEvent *e)
{
QPainter paint(this);
QFontMetrics fm(settings.RxLabelFont);
int xpos;
xpos=rxwindow->x()+(rxwindow->width()-fm.width(title)-10)/2;
drawFrame(&paint);
drawContents(&paint);
paint.setPen(settings.colours[channelNumber]);
paint.setFont(settings.RxLabelFont);
paint.drawText(xpos,0,xpos+fm.width(title)+10,fm.height()+4,AlignLeft,title);

}
/** sets the Remote callsign for this RxWindow */
void CRxdisplay::setTheirCall(const QString &call)
{
theircall.operator=(call);
}
/** sets the name of the remote Op for this RxWindow */
void CRxdisplay::setName(const QString &name)
{
Name.operator=(name);
}

void CRxdisplay::ChangedToMode(Mode modus)
{
emit ModeChanged(modus,channelNumber);
}


bool CRxdisplay::getAFCsetting()
{
return UseAfc;
}
